/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class EhcacheUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EhcacheUtil.class);
    @Autowired
    CacheManager cacheManager;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;

    public void insert(String cacheName, String key, Object value) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            cache.put((Object)key, value);
        }
    }

    public void insert(String cacheName, String key, Object value, int time) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Ehcache ehcache = (Ehcache)cache.getNativeCache();
            Element element = new Element((Object)key, value, time, time);
            ehcache.put(element);
        }
    }

    public void expire(String cacheName, String key, int time) {
        if (time > 0) {
            this.insert(cacheName, key, time);
        } else {
            this.insert(cacheName, key, 3600);
        }
    }

    public void remove(String key) {
        Collection cacheNames = this.cacheManager.getCacheNames();
        if (CollectionUtil.isNotEmpty((Collection)cacheNames)) {
            for (String name : cacheNames) {
                Cache cache = this.cacheManager.getCache(name);
                Ehcache ehcache = (Ehcache)cache.getNativeCache();
                ehcache.remove((Serializable)((Object)key));
            }
        }
    }

    public void remove(String cacheName, String key) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Ehcache ehcache = (Ehcache)cache.getNativeCache();
            ehcache.remove((Serializable)((Object)key));
        }
    }

    public void removeHash(String cacheName, String key) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Ehcache ehcache = (Ehcache)cache.getNativeCache();
            ehcache.remove((Serializable)((Object)key));
        }
    }

    public Object query(String key) {
        Collection cacheNames = this.cacheManager.getCacheNames();
        if (CollectionUtil.isNotEmpty((Collection)cacheNames)) {
            for (String name : cacheNames) {
                Cache cache = this.cacheManager.getCache(name);
                Cache.ValueWrapper valueWrapper = cache.get((Object)key);
                if (!ObjectUtil.isNotEmpty((Object)valueWrapper)) continue;
                return valueWrapper.get();
            }
        }
        return null;
    }

    public Object query(String cacheName, String key) {
        if (StringUtils.isNotEmpty(cacheName) && StringUtils.isNotEmpty(key)) {
            Cache cache = this.cacheManager.getCache(cacheName);
            Cache.ValueWrapper valueWrapper = cache.get((Object)key);
            return ObjectUtil.isEmpty((Object)valueWrapper) ? null : valueWrapper.get();
        }
        return null;
    }

    public <K, V> Map<K, V> getMap(String key) {
        Object o;
        if (StringUtils.isNotEmpty(key) && ObjectUtil.isNotEmpty((Object)(o = this.query(key))) && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public <V> List<V> getList(String key) {
        Object o;
        if (StringUtils.isNotEmpty(key) && ObjectUtil.isNotEmpty((Object)(o = this.query(key))) && o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public Set<Object> getSet(String key) {
        Object o;
        if (StringUtils.isNotEmpty(key) && ObjectUtil.isNotEmpty((Object)(o = this.query(key))) && o instanceof Set) {
            return (Set)o;
        }
        return null;
    }

    public boolean exists(String key) {
        return this.exists(null, key);
    }

    public boolean exists(String cacheName, String key) {
        if (StringUtils.isNotEmpty(key)) {
            Iterator iterator;
            Collection cacheNames = new ArrayList<String>();
            if (StringUtils.isEmpty(cacheName)) {
                cacheNames = this.cacheManager.getCacheNames();
            } else {
                cacheNames.add(cacheName);
            }
            if (CollectionUtil.isNotEmpty(cacheNames) && (iterator = cacheNames.iterator()).hasNext()) {
                String name = (String)iterator.next();
                Cache cache = this.cacheManager.getCache(name);
                Cache.ValueWrapper valueWrapper = cache.get((Object)key);
                return ObjectUtil.isNotEmpty((Object)valueWrapper);
            }
        }
        return false;
    }

    public Set<String> getAllKeys() {
        return this.getAllKeys(null);
    }

    public Set<String> getAllKeys(String cacheName) {
        HashSet<String> keys = new HashSet<String>();
        Collection cacheNames = new ArrayList<String>();
        if (StringUtils.isEmpty(cacheName)) {
            cacheNames = this.cacheManager.getCacheNames();
        } else {
            cacheNames.add(cacheName);
        }
        if (CollectionUtil.isNotEmpty(cacheNames)) {
            for (String name : cacheNames) {
                Cache cache = this.cacheManager.getCache(name);
                Ehcache ehcache = (Ehcache)cache.getNativeCache();
                List keys1 = ehcache.getKeys();
                keys.addAll(keys1);
            }
        }
        return keys;
    }

    public Set<String> getAllVisiualKeys() {
        Set<String> ehcacheAllKeys = this.getAllKeys(null);
        return ehcacheAllKeys.stream().filter(o -> o.contains(this.cacheKeyUtil.getAllUser()) || o.contains(this.cacheKeyUtil.getCompanySelect()) || o.contains(this.cacheKeyUtil.getDictionary()) || o.contains(this.cacheKeyUtil.getDynamic()) || o.contains(this.cacheKeyUtil.getOrganizeList()) || o.contains(this.cacheKeyUtil.getPositionList()) || o.contains(this.cacheKeyUtil.getVisiualData())).collect(Collectors.toSet());
    }

    public Long getLiveTime(String key) {
        Collection cacheNames = this.cacheManager.getCacheNames();
        if (CollectionUtil.isNotEmpty((Collection)cacheNames)) {
            for (String name : cacheNames) {
                Cache cache = this.cacheManager.getCache(name);
                Ehcache ehcache = (Ehcache)cache.getNativeCache();
                Element element = ehcache.get((Serializable)((Object)key));
                if (!ObjectUtil.isNotEmpty((Object)element)) continue;
                return element.getExpirationTime();
            }
        }
        return 0L;
    }

    public Boolean setStringByAtomicity(String key, String value) throws Exception {
        Cache cache = this.cacheManager.getCache("RepeatSubmitCacheSpace");
        Ehcache ehcache = (Ehcache)cache.getNativeCache();
        Element element = ehcache.get((Serializable)((Object)key));
        if (ObjectUtil.isNotEmpty((Object)element) && value.equals(element.getObjectValue())) {
            return true;
        }
        element = new Element((Serializable)((Object)key), (Serializable)((Object)value));
        ehcache.put(element);
        return false;
    }
}

