/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.context.SpringContext;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.idgen.YitIdHelper;
import jakarta.annotation.PreDestroy;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class RandomUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RandomUtil.class);
    private static final String ID_IDX = CacheKeyUtil.IDGENERATOR + "Index_";
    @Autowired
    private RedisTemplate<String, Long> redisTemplate;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private CacheUtil cacheUtil;
    private static long CacheTimeout = 86400L;
    private static long ScheduleTimeout = 1800L;
    private static byte WorkerIdBitLength = (byte)16;
    private static int MaxWorkerIdNumberByMode = (1 << WorkerIdBitLength) - 1 > Short.MAX_VALUE ? Short.MAX_VALUE : (1 << WorkerIdBitLength) - 1;
    private static ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private short workerId = (short)-1;
    private String cacheKey;
    private Runnable resetExpire = () -> this.redisTemplate.opsForValue().set((Object)this.cacheKey, (Object)System.currentTimeMillis(), CacheTimeout, TimeUnit.SECONDS);

    @Bean
    private void initIdWorker() {
        this.redisTemplate = (RedisTemplate)SpringContext.getBean("redisTemplate");
        if (this.redisTemplate != null && CacheType.REDIS.equals((Object)this.cacheUtil.getCacheType())) {
            RedisAtomicLong redisAtomicLong = new RedisAtomicLong(ID_IDX, this.redisTemplate.getConnectionFactory());
            for (int i = 0; i <= MaxWorkerIdNumberByMode; ++i) {
                long andInc = redisAtomicLong.getAndIncrement();
                long result = andInc % (long)(MaxWorkerIdNumberByMode + 1);
                if (andInc >= (long)MaxWorkerIdNumberByMode) {
                    redisAtomicLong.set(andInc % (long)MaxWorkerIdNumberByMode);
                }
                this.cacheKey = ID_IDX + result;
                boolean useSuccess = this.redisTemplate.opsForValue().setIfAbsent((Object)this.cacheKey, (Object)System.currentTimeMillis(), CacheTimeout, TimeUnit.SECONDS);
                if (!useSuccess) continue;
                this.workerId = (short)result;
                break;
            }
            if (this.workerId == -1) {
                throw new RuntimeException(String.format("\u5df2\u5c1d\u8bd5\u751f\u6210%d\u4e2aID\u751f\u6210\u5668\u7f16\u53f7, \u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u7f16\u53f7", MaxWorkerIdNumberByMode + 1));
            }
        } else {
            this.workerId = (short)new Random().nextInt(MaxWorkerIdNumberByMode);
        }
        log.info("\u5f53\u524dID\u751f\u6210\u5668\u7f16\u53f7: " + this.workerId);
        IdGeneratorOptions options = new IdGeneratorOptions(this.workerId);
        options.WorkerIdBitLength = WorkerIdBitLength;
        YitIdHelper.setIdGenerator((IdGeneratorOptions)options);
        scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, this.threadPoolTaskExecutor.getThreadPoolExecutor().getThreadFactory());
        scheduledThreadPoolExecutor.scheduleWithFixedDelay(this.resetExpire, ScheduleTimeout, ScheduleTimeout, TimeUnit.SECONDS);
    }

    @PreDestroy
    private void onDestroy() {
        if (this.redisTemplate != null) {
            this.redisTemplate.delete((Object)this.cacheKey);
        }
    }

    public static String uuId() {
        long newId = YitIdHelper.nextId();
        return "" + newId;
    }

    public static String enUuid() {
        Object str = "";
        for (int i = 0; i < 6; ++i) {
            str = (String)str + (char)(Math.random() * 26.0 + 97.0);
        }
        return str;
    }

    public static Long parses() {
        Long time = 0L;
        return time;
    }

    public static String getRandomCode() {
        Object code = "";
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            int ran = rand.nextInt(10);
            code = (String)code + ran;
        }
        return code;
    }
}

