/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ReflectionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);
    private static boolean isDebug = false;

    public static Object invokeGetterMethod(Object obj, String propertyName) {
        String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value) {
        ReflectionUtil.invokeSetterMethod(obj, propertyName, value, null);
    }

    public static void invokeSetterMethod(Object obj, String propertyName, Object value, Class<?> propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = "set" + StringUtils.capitalize((String)propertyName);
        ReflectionUtil.invokeMethod(obj, setterMethodName, new Class[]{type}, new Object[]{value});
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtil.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + String.valueOf(obj) + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Throwable)e);
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtil.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + String.valueOf(obj) + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            log.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fieldName, (String)"fieldName");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + String.valueOf(obj) + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Boolean invokeMethodByTask(Object obj, String methodName, Class<?>[] parameterTypes, Map<String, Object> args) {
        Method method = ReflectionUtil.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            return false;
        }
        try {
            if (ObjectUtil.isEmpty(args)) {
                method.invoke(obj, new Object[0]);
            } else {
                method.invoke(obj, args);
            }
            return true;
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull((Object)obj, (String)"object\u4e0d\u80fd\u4e3a\u7a7a");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Method method = superClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static <T> Class<T> getSuperClassGenricType(Class<?> clazz) {
        return ReflectionUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection com.bringspring.exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection com.bringspring.exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked com.bringspring.exception.", e);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == Object.class || obj.getClass().isPrimitive()) {
            return obj.toString();
        }
        try {
            Method method = obj.getClass().getDeclaredMethod("toString", new Class[0]);
            if (isDebug) {
                log.debug("\u4f20\u5165\u7684\u5bf9\u8c61\u5b9e\u73b0\u4e86\u81ea\u5df1\u7684toString\u65b9\u6cd5\uff0c\u76f4\u63a5\u8c03\u7528\uff01");
            }
            return (String)method.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (isDebug) {
                log.debug("\u4f20\u5165\u7684\u5bf9\u8c61\u6ca1\u6709\u5b9e\u73b0\u81ea\u5df1\u7684toString\u65b9\u6cd5\uff0c\u53cd\u5c04\u83b7\u53d6\uff01");
            }
            StringBuffer buf = new StringBuffer(obj.getClass().getName());
            buf.append(" [");
            Field[] fileds = obj.getClass().getDeclaredFields();
            int size = fileds.length;
            for (int i = 0; i < size; ++i) {
                Field field = fileds[i];
                Object value = ReflectionUtil.getFieldValue(obj, field.getName());
                buf.append(field.getName() + "=" + ReflectionUtil.toString(value));
                if (i == size - 1) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Map<String, String> getDeclaredFieldsInfo2(Object instance, Map<String, String> fieldMap) throws NoSuchFieldException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Class<?> clazz = instance.getClass();
        Field[] fields = clazz.getDeclaredFields();
        boolean b = false;
        for (int i = 0; i < fields.length; ++i) {
            boolean annotationPresent;
            if (fieldMap.containsValue(fields[i].getName()) || !(annotationPresent = fields[i].isAnnotationPresent(Excel.class))) continue;
            String name = fields[i].getAnnotation(Excel.class).name();
            map.put(name, fields[i].getName());
        }
        return map;
    }
}

