/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.ConvertUtil;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static String getServletPath() {
        return ServletUtils.getRequest().getServletPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPayload() {
        String string;
        block7: {
            ServletInputStream is = ServletUtils.getRequest().getInputStream();
            try {
                String str;
                int nRead = 1;
                int nTotalRead = 0;
                byte[] bytes = new byte[204800];
                while (nRead > 0) {
                    nRead = is.read(bytes, nTotalRead, bytes.length - nTotalRead);
                    if (nRead <= 0) continue;
                    nTotalRead += nRead;
                }
                string = str = new String(bytes, 0, nTotalRead, "UTF-8");
                if (Collections.singletonList(is).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(is).get(0) != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "";
                }
            }
            is.close();
        }
        return string;
    }

    public static String getUserAgent() {
        return ServletUtils.getHeader("User-Agent");
    }

    public static boolean getIsMobileDevice() {
        return ServletUtils.isMobileDevice(ServletUtils.getUserAgent());
    }

    public static String getHeader(String name) {
        if (ServletUtils.getRequest() != null) {
            return ServletUtils.getRequest().getHeader(name);
        }
        return null;
    }

    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return ConvertUtil.toStr(ServletUtils.getRequest().getParameter(name), defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return ConvertUtil.toInt(ServletUtils.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return ConvertUtil.toInt(ServletUtils.getRequest().getParameter(name), defaultValue);
    }

    public static HttpServletRequest getRequest() {
        if (ServletUtils.getRequestAttributes() != null) {
            return ServletUtils.getRequestAttributes().getRequest();
        }
        return null;
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (ServletUtils.inStringIgnoreCase(uri, ".json", ".xml")) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return ServletUtils.inStringIgnoreCase(ajax, "json", "xml");
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(s.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static JSONObject getJsonObject() throws Exception {
        String builder = ServletUtils.getPayload();
        return JSONObject.parseObject((String)builder);
    }

    public static boolean isMobileDevice(String requestHeader) {
        String[] deviceArray = new String[]{"android", "windows phone", "iphone", "ios", "ipad", "mqqbrowser"};
        if (requestHeader == null) {
            return false;
        }
        requestHeader = requestHeader.toLowerCase();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (requestHeader.indexOf(deviceArray[i]) <= 0) continue;
            return true;
        }
        return false;
    }
}

