package com.bringspring.common.auth.consts;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Getter
@AllArgsConstructor
public enum DeviceType {

    /**
     * pc端
     */
    PC("PC"),

    /**
     * app端 手机都归为移动 自行扩展
     */
    APP("APP"),

    /**
     * 程序运行中使用的无限制临时用户
     */
    TEMPUSER("TEMPUSER"),


    /**
     * 程序运行中使用的限制临时用户， 不可访问主系统, CurrentUser接口报错
     */
    TEMPUSERLIMITED("TEMPUSERLIMITED");


    private final String device;

}
