package com.bringspring.common.auth.granter;

import com.bringspring.common.auth.consts.AuthConsts;
import com.bringspring.common.auth.service.UserDetailService;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Component
public class UserDetailsServiceBuilder {


    private final Map<String, UserDetailService> userDetailServices = new ConcurrentHashMap<>();

    public UserDetailsServiceBuilder(Map<String, UserDetailService> userDetailServices) {
        userDetailServices.forEach(this.userDetailServices::put);
    }


    /**
     * 根据类型获取合适的UserDetailService
     *
     * @param detailType
     * @return
     */
    public UserDetailService getUserDetailService(String detailType) {
        if (detailType == null) {
            detailType = AuthConsts.USERDETAIL_ACCOUNT;
        }
        return userDetailServices.get(detailType);
    }

}
