package com.bringspring.common.auth.service;


import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.PcUserVO;


/**
 * 登陆业务层
 *
 * @author RKKJ开发平台组
 * @version V3.1.0
 * @copyright 荣科科技股份有限公司（https://jsbos.bringspring.com）
 * @date 2021-03-23
 */
public interface LoginSatokenService {

    /**
     * 租戶登录验证
     *
     * @param userInfo
     * @return userAccount, tenantId, tenandDb
     * @throws LoginException
     */
    UserInfo getTenantAccount(UserInfo userInfo) throws LoginException;

    /**
     * 生成用户登录信息
     *
     * @param userInfo      账户信息
     * @param sysConfigInfo 系统配置
     * @return
     * @throws LoginException
     */
    UserInfo userInfo(UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException;

    /**
     * 获取用户登陆信息
     *
     * @return
     */
    PcUserVO getCurrentUser(String type, String systemCode, Integer isBackend);

    /**
     * 修改密码信息发送
     *
     * @return
     */
    void updatePasswordMessage();

    /**
     * @param tenantId
     * @return
     */
    BaseSystemInfo getBaseSystemConfig(String tenantId);

    String getConfigByKeyName(String keyName);

}
