package com.bringspring.common.database.model;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.bean.BeanUtil;
import lombok.Data;

import java.io.Serializable;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/31 17:41
 */
@Data
public class TenantLinkModel implements Serializable {
    /**
     * id
     */
    public String id;

    /**
     * 数据库名
     */
    @Alias("dbName")
    public String serviceName;

    /**
     * 数据库名
     */
    public String dbName;

    /**
     * 用户名
     */
    public String userName;

    /**
     * 端口
     */
    public String port;

    /**
     * 连接名称
     */
    public String fullName;

    /**
     * 主机地址
     */
    public String host;

    /**
     * 密码
     */
    public String password;

    /**
     * 模式
     */
    public String dbSchema;

    /**
     * 连接配置（0：主，1：从）
     */
    public Integer configType;

    /**
     * 数据库类型
     */
    public String dbType;

    /**
     * 自定义连接语句
     */
    @Alias("prepareUrl")
    public String connectionStr;

    public <T> T toDbLink(T obj){
        BeanUtil.copyProperties(this, obj);
        return obj;
    }
}
