package com.bringspring.common.database.model.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.dto.PrepSqlDTO;
import com.bringspring.common.database.util.DataSourceUtil;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 数据连接
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("base_db_link")
@NoArgsConstructor
public class DbLinkEntity extends DataSourceUtil {
    /**
     * 连接主键
     */
    @TableId("ID")
    private String id;

    /**
     * 连接名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * Oracle扩展开关
     */
    @TableField("ORACLE_EXTEND")
    private Integer oracleExtend;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;
    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

//    @Override
//    public DataSourceDTO convertDTO(){
//        return convertDTO(null);
//    }
//
//    @Override
//    public DataSourceDTO convertDTO(String dbName){
//        try{
//            return convertDTO(dbName, 2);
//        }catch (Exception e){
//            e.printStackTrace();
//        }
//        return null;
//    }

    public static DbLinkEntity newInstance(String dbLinkId){
        return PrepSqlDTO.DB_LINK_FUN.apply(dbLinkId);
    }

    public DbLinkEntity(String dbType){
        super.setDbType(dbType);
    }

}