package com.bringspring.common.event;

import com.bringspring.common.event.strategy.ActionMethodContext;
import com.bringspring.common.event.strategy.ActionStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

/**
 * 消息监听器
 */

@Component
public class GeneralListener {

    @Autowired
    private ActionMethodContext actionMethodContext;

    /**
     * 收到消息事件执行
     * @param event
     */
    @EventListener
    public void onApplicationEvent(GeneralEvent event) {
        String source = event.getSource().toString();
        ActionStrategy actionStrategy = actionMethodContext.getActionMethod(source);
        actionStrategy.handler(event);

    }
}
