package com.bringspring.common.i18n.core;

import com.bringspring.common.constant.model.MCode;
import com.bringspring.common.i18n.provider.I18nMessageProvider;
import org.springframework.context.support.AbstractMessageSource;

import java.text.MessageFormat;
import java.util.Locale;

/**
 * 自定义消息来源
 */
public class DynamicMessageSource extends AbstractMessageSource {


    private I18nMessageProvider i18nMessageProvider;

    public DynamicMessageSource(I18nMessageProvider i18nMessageProvider) {
        this.i18nMessageProvider = i18nMessageProvider;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MCode i18nMessage = i18nMessageProvider.getI18nMessage(code, locale);
        if(i18nMessage != null){
            return createMessageFormat(i18nMessage.getDesc(), locale);
        }
        return null;
    }
}
