package com.bringspring.common.sms.util.message;

import com.bringspring.common.base.SmsModel;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 短信工具类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-11
 */
@Component
public class SmsUtil {

    /**
     * 获取短信模板参数
     *
     * @param type
     * @param smsModel
     * @param templateId
     * @return
     */
    public static List<String> querySmsTemplateRequest(Integer type, SmsModel smsModel, String endpoint, String region, String templateId) {
        if (type == 1) {
            return SmsAliYunUtil.querySmsTemplateRequest(smsModel.getAliAccessKey(), smsModel.getAliSecret(), endpoint, templateId);
        }
        return SmsTenCentCloudUtil.querySmsTemplateRequest(smsModel.getTencentSecretId(), smsModel.getTencentSecretKey(), endpoint, region, templateId);
    }

    /**
     * 发送消息
     *
     * @param type
     * @param smsModel
     * @param phoneNumbers
     * @param signContent
     * @param templateId
     * @param map
     * @return
     */
    public static String sentSms(Integer type, SmsModel smsModel, String endpoint, String region, String phoneNumbers, String signContent, String templateId, Map<String, String> map) {
        if (type == 1) {
            return SmsAliYunUtil.sentSms(smsModel.getAliAccessKey(), smsModel.getAliSecret(), endpoint, phoneNumbers, signContent, templateId, map);
        }
        return SmsTenCentCloudUtil.sentSms(smsModel.getTencentSecretId(), smsModel.getTencentSecretKey(), endpoint, region, phoneNumbers, smsModel.getTencentAppId(), signContent, templateId, map);
    }

}
