/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.granter;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import com.bringspring.common.auth.consts.DeviceType;
import com.bringspring.common.auth.consts.LoginTicketStatus;
import com.bringspring.common.auth.granter.TokenGranter;
import com.bringspring.common.auth.model.LoginTicketModel;
import com.bringspring.common.auth.service.LoginSatokenService;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.auth.util.TicketUtil;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import com.bringspring.common.exception.TenantDatabaseException;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.logout.LogoutResultModel;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.RedisUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public abstract class AbstractTokenGranter
implements TokenGranter,
Ordered {
    @Autowired(required=false)
    protected LoginSatokenService loginSatokenService;
    @Autowired
    protected ConfigValueUtil configValueUtil;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected CacheUtil cacheUtil;
    protected static PathMatcher pathMatcher = new AntPathMatcher();
    private String authenticationUrl;

    public AbstractTokenGranter(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    protected String loginAccount(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
        try {
            userInfo.setUserDetailKey(this.getUserDetailKey());
            userInfo = this.getUserInfo(userInfo, baseSystemInfo);
            this.preLogin(userInfo, baseSystemInfo);
            this.login(userInfo, baseSystemInfo);
        }
        catch (Exception e) {
            this.loginFailure(userInfo, baseSystemInfo, e);
            throw e;
        }
        this.loginSuccess(userInfo, baseSystemInfo);
        return userInfo.getToken();
    }

    protected UserInfo switchTenant(UserInfo userInfo) throws LoginException {
        if (this.configValueUtil.isMultiTenancy()) {
            userInfo = this.loginSatokenService.getTenantAccount(userInfo);
            return userInfo;
        }
        userInfo.setTenantId("");
        userInfo.setTenantDbConnectionString("");
        userInfo.setTenantDbType(-1);
        return userInfo;
    }

    protected BaseSystemInfo getSysconfig(UserInfo userInfo) throws LoginException {
        BaseSystemInfo baseSystemInfo = this.loginSatokenService.getBaseSystemConfig(userInfo.getTenantId());
        if (baseSystemInfo == null || baseSystemInfo.getSingleLogin() == null) {
            throw new TenantDatabaseException().setLogMsg(MsgCode.LOG110.get());
        }
        TenantProvider.setBaseSystemInfo(baseSystemInfo);
        return baseSystemInfo;
    }

    protected String getConfigByKeyName(String keyName) throws LoginException {
        return this.loginSatokenService.getConfigByKeyName(keyName);
    }

    protected DeviceType getDeviceType() {
        return UserProvider.getDeviceForAgent();
    }

    protected UserInfo getUserInfo(UserInfo userInfo, BaseSystemInfo sysConfigInfo) throws LoginException {
        userInfo.setGrantType(this.getGrantType());
        userInfo = this.loginSatokenService.userInfo(userInfo, sysConfigInfo);
        return userInfo;
    }

    protected void preLogin(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
    }

    protected void login(UserInfo userInfo, BaseSystemInfo baseSystemInfo) throws LoginException {
        UserProvider.login(userInfo, this.getLoginModel(userInfo, baseSystemInfo));
    }

    protected void loginSuccess(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
    }

    protected void loginFailure(UserInfo userInfo, BaseSystemInfo baseSystemInfo, Exception e) {
    }

    protected abstract String getUserDetailKey();

    protected String createToken(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
        UserProvider.login(userInfo, this.getLoginModel(userInfo, baseSystemInfo));
        return StpUtil.getTokenValueNotCut();
    }

    protected void updateTicketSuccess(UserInfo userInfo) {
        String ticket = this.getJsbosTicket();
        if (!ticket.isEmpty()) {
            LoginTicketModel loginTicketModel = new LoginTicketModel().setStatus(LoginTicketStatus.Success.getStatus()).setValue(StpUtil.getTokenValueNotCut()).setTheme(userInfo.getTheme());
            TicketUtil.updateTicket(ticket, loginTicketModel, null);
        }
    }

    protected void updateTicketError(String msg) {
        String ticket = this.getJsbosTicket();
        if (!ticket.isEmpty()) {
            LoginTicketModel loginTicketModel = new LoginTicketModel().setStatus(LoginTicketStatus.ErrLogin.getStatus()).setValue(msg);
            TicketUtil.updateTicket(ticket, loginTicketModel, null);
        }
    }

    protected String getJsbosTicket() {
        return SaHolder.getRequest().getParam("jsbos_ticket", "");
    }

    protected boolean isValidJsbosTicket() {
        LoginTicketModel loginTicketModel;
        String jsbosTicket = this.getJsbosTicket();
        return jsbosTicket.isEmpty() || (loginTicketModel = (LoginTicketModel)TicketUtil.parseTicket(jsbosTicket)) != null;
    }

    protected SaLoginParameter getLoginModel(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
        SaLoginParameter loginModel = new SaLoginParameter();
        loginModel.setTimeout((long)userInfo.getTokenTimeout().intValue() * 60L);
        loginModel.setExtraData(this.getTokenExtraData(userInfo, baseSystemInfo));
        if (userInfo.getLoginDevice() == null) {
            loginModel.setDevice(this.getDeviceType().getDevice());
            userInfo.setLoginDevice(loginModel.getDeviceType());
        } else {
            loginModel.setDevice(userInfo.getLoginDevice());
        }
        return loginModel;
    }

    protected Map<String, Object> getTokenExtraData(UserInfo userInfo, BaseSystemInfo baseSystemInfo) {
        HashMap<String, Object> tokenInfo = new HashMap<String, Object>();
        tokenInfo.put("singleLogin", baseSystemInfo == null ? null : baseSystemInfo.getSingleLogin());
        tokenInfo.put("user_name", userInfo.getUserAccount());
        tokenInfo.put("user_id", userInfo.getUserId());
        tokenInfo.put("exp", userInfo.getOverdueTime().getTime());
        tokenInfo.put("token", userInfo.getId());
        return tokenInfo;
    }

    @Override
    public ActionResult<LogoutResultModel> logout() {
        UserProvider.logout();
        return ActionResult.success();
    }

    protected abstract String getGrantType();

    @Override
    public boolean requiresAuthentication() {
        String path = SaHolder.getRequest().getRequestPath();
        if (path != null && path.startsWith("/api/oauth")) {
            path = path.replace("/api/oauth", "");
        }
        return pathMatcher.match(this.authenticationUrl, path);
    }
}

