/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.auth.granter;

import com.bringspring.common.auth.config.JsbosOauthConfig;
import com.bringspring.common.auth.granter.TokenGranter;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.LoginException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenGranterBuilder {
    @Autowired
    private JsbosOauthConfig oauthConfig;
    private final Map<String, TokenGranter> granterPool = new ConcurrentHashMap<String, TokenGranter>();

    public TokenGranterBuilder(Map<String, TokenGranter> granterPool) {
        granterPool.forEach(this.granterPool::put);
    }

    public TokenGranter getGranter(String grantType) throws LoginException {
        TokenGranter tokenGranter = null;
        if (!this.oauthConfig.getSsoEnabled().booleanValue() || "tempuser".equalsIgnoreCase(grantType)) {
            tokenGranter = this.granterPool.get(grantType);
        }
        if (tokenGranter == null) {
            for (TokenGranter value : this.granterPool.values()) {
                if (!value.requiresAuthentication()) continue;
                tokenGranter = value;
                break;
            }
        }
        if (tokenGranter == null) {
            if (this.oauthConfig.getSsoEnabled().booleanValue()) {
                throw new LoginException(MsgCode.LOG111.get());
            }
            throw new LoginException(MsgCode.LOG112.get());
        }
        return tokenGranter;
    }

    public TokenGranter getGranterByLogin(String grandType) {
        if (grandType == null || grandType.isEmpty()) {
            UserInfo userInfo = UserProvider.getUser();
            grandType = userInfo.getGrantType() != null ? userInfo.getGrantType() : "password";
        }
        return this.granterPool.get(grandType);
    }
}

