/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.config;

import cn.hutool.http.useragent.Browser;
import cn.hutool.http.useragent.OS;
import cn.hutool.http.useragent.Platform;
import com.bringspring.common.config.ApplicationStartErrorCheck;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.i18n.config.I18nProperties;
import com.bringspring.common.properties.GatewayWhite;
import com.bringspring.common.properties.MvcSecurityProperties;
import com.bringspring.common.properties.SecurityProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
public class CoreAutoConfiguration
implements InitializingBean {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="gateway")
    public GatewayWhite getGateWhite() {
        return new GatewayWhite();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="security")
    public SecurityProperties getSecurityProperties() {
        return new SecurityProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="config")
    public ConfigValueUtil getConfigValueUtil() {
        return new ConfigValueUtil();
    }

    @Bean
    @Primary
    @ConfigurationProperties(prefix="spring.messages")
    public I18nProperties getI18nProperties() {
        return new I18nProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.mvc")
    public MvcSecurityProperties getCorsProperties() {
        return new MvcSecurityProperties();
    }

    @Bean
    public ApplicationStartErrorCheck getApplicationStartupErrorCheck() {
        return new ApplicationStartErrorCheck();
    }

    public void afterPropertiesSet() {
        this.initUserAgent();
    }

    private void initUserAgent() {
        OS.addCustomOs((String)"OpenHarmony", (String)"OpenHarmony", (String)"OpenHarmony\\s+(\\d+([._]\\d+)*)");
        Platform platform = new Platform("OpenHarmony", "Phone;\\s*OpenHarmony\\s*");
        Platform.mobilePlatforms.add(platform);
        Platform.platforms.add(platform);
        Browser.browers.add(0, new Browser("OpenHarmony", "Phone;\\s*OpenHarmony.*ArkWeb", "ArkWeb\\/([\\d\\w\\.\\-]+)"));
        Browser.browers.add(1, new Browser("WindowsWechat", "MicroMessenger\\/.*WindowsWechat", "MicroMessenger\\/([\\d\\w\\.\\-]+)"));
        Browser.browers.add(1, new Browser("DingTalk-PC", "DTWKWebView Channel", "DTWKWebView Channel\\/([\\d\\w\\.\\-]+)"));
    }
}

