/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums.datatype;

import com.bringspring.common.database.enums.datatype.interfaces.DtInterface;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbDM;

public enum DtDM implements DtInterface
{
    VARCHAR("VARCHAR", "varchar", 50, 8189),
    DATA_TIME("DATETIME", "datetime", false),
    TIME_STAMP("TIMESTAMP", "datetime", false),
    TIME("TIME", "datetime", false),
    DATE("DATE", "datetime", false),
    DECIMAL("DECIMAL", "decimal", 22, 38, 6, 38),
    DEC("DEC", "decimal", 22, 38, 6, 38),
    TEXT("TEXT", "text", false),
    CLOB("CLOB", "text", false),
    INT("INT", "int", false),
    BIGINT("BIGINT", "bigint", false);

    public final DbBase dbBase = new DbDM();
    private final String dbFieldType;
    private final Boolean lengthModifyFlag;
    private final String viewDataType;
    private final Integer defaultLength;
    private final Integer lengthMax;
    private final Integer defaultPrecision;
    private final Integer precisionMax;

    private DtDM(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax, Integer defaultPrecision, Integer precisionMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = defaultPrecision;
        this.precisionMax = precisionMax;
    }

    private DtDM(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    private DtDM(String dbFieldType, String viewDataType, Boolean lengthModifyFlag) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = lengthModifyFlag;
        this.viewDataType = viewDataType;
        this.defaultLength = null;
        this.lengthMax = null;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    @Override
    public DataTypeModel getDataTypeModel() {
        return new DataTypeModel(this.dbFieldType, this.viewDataType, this.defaultLength, this.lengthMax, this.lengthModifyFlag, this.defaultPrecision, this.precisionMax);
    }

    @Override
    public String getDbFieldType() {
        return this.dbFieldType;
    }
}

