/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums.datatype;

import com.bringspring.common.database.enums.datatype.interfaces.DtInterface;
import com.bringspring.common.database.model.DataTypeModel;

public enum DtSQLServer implements DtInterface
{
    NVARCHAR("nvarchar", "varchar", 50, 4000),
    VARCHAR("varchar", "varchar", 50, 8000),
    VARCHAR_MAX("nvarchar(max)", "varchar", false),
    DATA_TIME("datetime", "datetime", false),
    DECIMAL("decimal", "decimal", 18, 38, 0, 18),
    TEXT("text", "text", false),
    INT("int", "int", false),
    BIGINT("bigint", "bigint", false);

    private final String dbFieldType;
    private final Boolean lengthModifyFlag;
    private final String viewDataType;
    private final Integer defaultLength;
    private final Integer lengthMax;
    private final Integer defaultPrecision;
    private final Integer precisionMax;

    private DtSQLServer(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax, Integer defaultPrecision, Integer precisionMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = defaultPrecision;
        this.precisionMax = precisionMax;
    }

    private DtSQLServer(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    private DtSQLServer(String dbFieldType, String viewDataType, Boolean lengthModifyFlag) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = lengthModifyFlag;
        this.viewDataType = viewDataType;
        this.defaultLength = null;
        this.lengthMax = null;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    @Override
    public DataTypeModel getDataTypeModel() {
        return new DataTypeModel(this.dbFieldType, this.viewDataType, this.defaultLength, this.lengthMax, this.lengthModifyFlag, this.defaultPrecision, this.precisionMax);
    }

    @Override
    public String getDbFieldType() {
        return this.dbFieldType;
    }
}

