/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model.dbtable;

import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.dbfield.DbFieldModel;
import com.bringspring.common.database.model.dbfield.JdbcColumnModel;
import com.bringspring.common.database.model.dbtable.DbTableFieldModel;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.exception.DataException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class JdbcTableModel {
    private String dbEncode;
    private String table;
    private String tableType;
    private String comment;
    private String primaryField;
    private List<String> primaryFields;
    private List<JdbcColumnModel> jdbcColumnModelList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcTableModel(DbLinkEntity dbLinkEntity, String table) throws Exception {
        block9: {
            Connection conn = ConnUtil.ConnCommon.getConnRemarks(dbLinkEntity);
            try {
                ResultSet rs = JdbcTableModel.getTableMetaDateRs(conn, table);
                try {
                    List primaryKeys = JdbcTableModel.getPrimaryKeys(conn, table).stream().sorted((o1, o2) -> "fid".equalsIgnoreCase((String)o2) || "id".equalsIgnoreCase((String)o2) ? 1 : 0).collect(Collectors.toList());
                    if (rs.next()) {
                        this.dbEncode = dbLinkEntity.getDbType();
                        this.table = rs.getString("TABLE_NAME");
                        this.tableType = rs.getString("TABLE_TYPE");
                        this.comment = rs.getString("REMARKS");
                        this.primaryField = primaryKeys.isEmpty() ? null : (String)primaryKeys.get(0);
                        this.primaryFields = primaryKeys;
                        this.jdbcColumnModelList = JdbcColumnModel.getList(conn, table, this.primaryFields);
                        break block9;
                    }
                    throw new DataException(MsgCode.DB009.get(table));
                }
                finally {
                    if (Collections.singletonList(rs).get(0) != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
    }

    public DbTableFieldModel convertDbTableFieldModel() throws Exception {
        DbTableFieldModel dbTableFieldModel = new DbTableFieldModel();
        dbTableFieldModel.setTable(this.table);
        dbTableFieldModel.setComment(this.comment);
        ArrayList<DbFieldModel> dbFieldModelList = new ArrayList<DbFieldModel>();
        for (JdbcColumnModel jdbcColumnModel : this.jdbcColumnModelList) {
            dbFieldModelList.add(jdbcColumnModel.convertDbFieldModel(this.dbEncode));
        }
        dbTableFieldModel.setDbFieldModelList(dbFieldModelList);
        return dbTableFieldModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JdbcTableModel> getList(Connection conn) throws Exception {
        ResultSet rs = JdbcTableModel.getTableMetaDateRs(conn);
        try {
            ArrayList<JdbcTableModel> list = new ArrayList<JdbcTableModel>();
            while (rs.next()) {
                JdbcTableModel jdbcTableModel = new JdbcTableModel();
                jdbcTableModel.setTable(rs.getString("TABLE_NAME"));
                jdbcTableModel.setTableType(rs.getString("TABLE_TYPE"));
                jdbcTableModel.setComment(rs.getString("REMARKS"));
                jdbcTableModel.setJdbcColumnModelList(JdbcColumnModel.getList(conn, jdbcTableModel.getTable(), jdbcTableModel.getPrimaryFields()));
                list.add(jdbcTableModel);
            }
            ArrayList<JdbcTableModel> arrayList = list;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(rs).get(0) != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrimary(DbSourceOrDbLink dbSourceOrDbLink, String table) throws SQLException {
        Connection conn = ConnUtil.getConnOrDefault(dbSourceOrDbLink);
        try {
            String string = JdbcTableModel.getPrimary(conn, table);
            return string;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static String getPrimaryExculde(Connection conn, String table, String ... excludeField) throws SQLException {
        List<String> primaryKeys = JdbcTableModel.getPrimaryKeys(conn, table);
        if (!primaryKeys.isEmpty()) {
            for (String primaryKey : primaryKeys) {
                boolean exlude = false;
                for (String exclude : excludeField) {
                    if (!primaryKey.equalsIgnoreCase(exclude)) continue;
                    exlude = true;
                    break;
                }
                if (exlude) continue;
                return primaryKey;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrimaryExculde(DbSourceOrDbLink dbSourceOrDbLink, String table, String ... excludeField) throws SQLException {
        Connection conn = ConnUtil.getConnOrDefault(dbSourceOrDbLink);
        try {
            String string = JdbcTableModel.getPrimaryExculde(conn, table, excludeField);
            return string;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static String getPrimary(Connection conn, String table) throws SQLException {
        List<String> primaryKeys = JdbcTableModel.getPrimaryKeys(conn, table);
        return primaryKeys.isEmpty() ? "" : primaryKeys.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrimaryIdFirst(DbSourceOrDbLink dbSourceOrDbLink, String table) throws SQLException {
        Connection conn = ConnUtil.getConnOrDefault(dbSourceOrDbLink);
        try {
            String string = JdbcTableModel.getPrimaryIdFirst(conn, table);
            return string;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    public static String getPrimaryIdFirst(Connection conn, String table) throws SQLException {
        String primaryKey;
        List<String> primaryKeys = JdbcTableModel.getPrimaryKeys(conn, table);
        String findedId = "";
        Iterator<String> iterator = primaryKeys.iterator();
        while (iterator.hasNext() && !"fid".equalsIgnoreCase(findedId = (primaryKey = iterator.next())) && !"id".equalsIgnoreCase(findedId)) {
        }
        return findedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPrimaryKeys(DbSourceOrDbLink dbSourceOrDbLink, String table) throws SQLException {
        Connection conn = ConnUtil.getConnOrDefault(dbSourceOrDbLink);
        try {
            List<String> list = JdbcTableModel.getPrimaryKeys(conn, table);
            return list;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPrimaryKeys(Connection conn, String table) throws SQLException {
        ResultSet rs = conn.getMetaData().getPrimaryKeys(conn.getCatalog(), null, table);
        try {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            while (rs.next()) {
                primaryKeys.add(rs.getString("COLUMN_NAME"));
            }
            ArrayList<String> arrayList = primaryKeys;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(rs).get(0) != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> getPrimaryMapList(Connection conn, String schema) throws SQLException {
        ResultSet rs = conn.getMetaData().getPrimaryKeys(conn.getCatalog(), schema, null);
        try {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"));
                list.add(map);
            }
            ArrayList<Map<String, String>> arrayList = list;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(rs).get(0) != null) {
                rs.close();
            }
        }
    }

    public static ResultSet getTableMetaDateRs(Connection conn, String table) throws SQLException {
        return conn.getMetaData().getTables(conn.getCatalog(), null, table, new String[]{"TABLE"});
    }

    private static ResultSet getTableMetaDateRs(Connection conn) throws SQLException {
        return JdbcTableModel.getTableMetaDateRs(conn, null);
    }

    @Generated
    public String getDbEncode() {
        return this.dbEncode;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getTableType() {
        return this.tableType;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getPrimaryField() {
        return this.primaryField;
    }

    @Generated
    public List<String> getPrimaryFields() {
        return this.primaryFields;
    }

    @Generated
    public List<JdbcColumnModel> getJdbcColumnModelList() {
        return this.jdbcColumnModelList;
    }

    @Generated
    public void setDbEncode(String dbEncode) {
        this.dbEncode = dbEncode;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setPrimaryField(String primaryField) {
        this.primaryField = primaryField;
    }

    @Generated
    public void setPrimaryFields(List<String> primaryFields) {
        this.primaryFields = primaryFields;
    }

    @Generated
    public void setJdbcColumnModelList(List<JdbcColumnModel> jdbcColumnModelList) {
        this.jdbcColumnModelList = jdbcColumnModelList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcTableModel)) {
            return false;
        }
        JdbcTableModel other = (JdbcTableModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbEncode = this.getDbEncode();
        String other$dbEncode = other.getDbEncode();
        if (this$dbEncode == null ? other$dbEncode != null : !this$dbEncode.equals(other$dbEncode)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$primaryField = this.getPrimaryField();
        String other$primaryField = other.getPrimaryField();
        if (this$primaryField == null ? other$primaryField != null : !this$primaryField.equals(other$primaryField)) {
            return false;
        }
        List<String> this$primaryFields = this.getPrimaryFields();
        List<String> other$primaryFields = other.getPrimaryFields();
        if (this$primaryFields == null ? other$primaryFields != null : !((Object)this$primaryFields).equals(other$primaryFields)) {
            return false;
        }
        List<JdbcColumnModel> this$jdbcColumnModelList = this.getJdbcColumnModelList();
        List<JdbcColumnModel> other$jdbcColumnModelList = other.getJdbcColumnModelList();
        return !(this$jdbcColumnModelList == null ? other$jdbcColumnModelList != null : !((Object)this$jdbcColumnModelList).equals(other$jdbcColumnModelList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JdbcTableModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbEncode = this.getDbEncode();
        result = result * 59 + ($dbEncode == null ? 43 : $dbEncode.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $primaryField = this.getPrimaryField();
        result = result * 59 + ($primaryField == null ? 43 : $primaryField.hashCode());
        List<String> $primaryFields = this.getPrimaryFields();
        result = result * 59 + ($primaryFields == null ? 43 : ((Object)$primaryFields).hashCode());
        List<JdbcColumnModel> $jdbcColumnModelList = this.getJdbcColumnModelList();
        result = result * 59 + ($jdbcColumnModelList == null ? 43 : ((Object)$jdbcColumnModelList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JdbcTableModel(dbEncode=" + this.getDbEncode() + ", table=" + this.getTable() + ", tableType=" + this.getTableType() + ", comment=" + this.getComment() + ", primaryField=" + this.getPrimaryField() + ", primaryFields=" + String.valueOf(this.getPrimaryFields()) + ", jdbcColumnModelList=" + String.valueOf(this.getJdbcColumnModelList()) + ")";
    }

    @Generated
    public JdbcTableModel() {
    }
}

