/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model.dto;

import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.sql.DataSource;
import lombok.Generated;

public class PrepSqlDTO {
    public static Function<String, DbLinkEntity> DB_LINK_FUN;
    private DbLinkEntity dbLinkEntity;
    private Connection preConnection;
    private String sql;
    private List<?> dataList = new ArrayList();
    private List<List<?>> multiDataList = new ArrayList();
    private String sqlCommandType;
    public static final String INSERT = "insert";
    public static final String DELETE = "delete";
    public static final String UPDATE = "update";
    public static final String SELECT = "select";
    public static final String CRE_UP_DE = "creUpDe";

    private static DataSource getDataSource() {
        return SpringContext.getBean(DataSource.class);
    }

    public static Connection getConn(DbLinkEntity dbLinkEntity) throws DataException {
        try {
            return new PrepSqlDTO().withConn(dbLinkEntity).switchConn().getConnection();
        }
        catch (SQLException d) {
            d.printStackTrace();
            throw new DataException(d.getMessage());
        }
    }

    private Connection getConnection() throws SQLException {
        try {
            Connection conn = DynamicDataSourceUtil.getCurrentConnection();
            ConnUtil.switchConnectionSchema(conn);
            Connection connection = conn;
            return connection;
        }
        finally {
            DynamicDataSourceUtil.clearSwitchDataSource();
        }
    }

    public PrepSqlDTO switchConn() throws SQLException, DataException {
        if (this.preConnection == null) {
            if (this.dbLinkEntity != null) {
                if (this.dbLinkEntity.getId() != null && !"0".equals(this.dbLinkEntity.getId())) {
                    DynamicDataSourceUtil.switchToDataSource(this.dbLinkEntity);
                } else if (this.dbLinkEntity.getUrl() != null) {
                    DynamicDataSourceUtil.switchToDataSource(this.dbLinkEntity.getUserName(), this.dbLinkEntity.getPassword(), this.dbLinkEntity.getUrl(), this.dbLinkEntity.getDbType());
                } else {
                    DynamicDataSourceUtil.switchToDataSource(null);
                }
            } else {
                throw new SQLException("dbLinkEntity\u6570\u636e\u5e93\u8fde\u63a5\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return this;
    }

    public PrepSqlDTO(String sql) {
        this.sql = sql;
    }

    public PrepSqlDTO(String sql, Object ... objs) {
        this.sql = sql;
        this.dataList = Arrays.asList(objs);
    }

    public PrepSqlDTO(String sql, List<?> prepareDataList) {
        this.sql = sql;
        this.dataList = prepareDataList;
    }

    public PrepSqlDTO withConn(String dbLinkId) {
        this.dbLinkEntity = DB_LINK_FUN.apply(dbLinkId);
        return this;
    }

    public PrepSqlDTO withConn(DbLinkEntity dbLinkEntity) {
        this.dbLinkEntity = dbLinkEntity;
        return this;
    }

    public PrepSqlDTO withConn(DataSourceUtil dataSourceUtil, String dbName) {
        this.dbLinkEntity = dataSourceUtil.init(dbName);
        return this;
    }

    public PrepSqlDTO withConn(String user, String password, String url) {
        this.dbLinkEntity = new DbLinkEntity();
        this.dbLinkEntity.setUserName(user);
        this.dbLinkEntity.setPassword(password);
        this.dbLinkEntity.setUrl(url);
        return this;
    }

    public PrepSqlDTO withConn(Connection conn) {
        this.preConnection = conn;
        return this;
    }

    public void addMultiData(List<?> prepareDataList) {
        this.multiDataList.add(prepareDataList);
    }

    public void addMultiData(Object ... objs) {
        this.multiDataList.add(Arrays.asList(objs));
    }

    public Map<String, Object> getMapParams() {
        String sql = XSSEscape.escapeEmpty(this.sql);
        for (int index = 0; sql.contains("?") && index <= this.dataList.size(); ++index) {
            sql = sql.replaceFirst("\\?", "\\#{param_" + index + "}");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sql", sql);
        for (int i = 0; i < this.dataList.size(); ++i) {
            Object dataObject = this.dataList.get(i);
            params.put("param_" + i, dataObject);
        }
        return params;
    }

    @Generated
    public DbLinkEntity getDbLinkEntity() {
        return this.dbLinkEntity;
    }

    @Generated
    public Connection getPreConnection() {
        return this.preConnection;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<?> getDataList() {
        return this.dataList;
    }

    @Generated
    public List<List<?>> getMultiDataList() {
        return this.multiDataList;
    }

    @Generated
    public String getSqlCommandType() {
        return this.sqlCommandType;
    }

    @Generated
    public PrepSqlDTO setDbLinkEntity(DbLinkEntity dbLinkEntity) {
        this.dbLinkEntity = dbLinkEntity;
        return this;
    }

    @Generated
    public PrepSqlDTO setPreConnection(Connection preConnection) {
        this.preConnection = preConnection;
        return this;
    }

    @Generated
    public PrepSqlDTO setSql(String sql) {
        this.sql = sql;
        return this;
    }

    @Generated
    public PrepSqlDTO setDataList(List<?> dataList) {
        this.dataList = dataList;
        return this;
    }

    @Generated
    public PrepSqlDTO setMultiDataList(List<List<?>> multiDataList) {
        this.multiDataList = multiDataList;
        return this;
    }

    @Generated
    public PrepSqlDTO setSqlCommandType(String sqlCommandType) {
        this.sqlCommandType = sqlCommandType;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrepSqlDTO)) {
            return false;
        }
        PrepSqlDTO other = (PrepSqlDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DbLinkEntity this$dbLinkEntity = this.getDbLinkEntity();
        DbLinkEntity other$dbLinkEntity = other.getDbLinkEntity();
        if (this$dbLinkEntity == null ? other$dbLinkEntity != null : !((Object)this$dbLinkEntity).equals(other$dbLinkEntity)) {
            return false;
        }
        Connection this$preConnection = this.getPreConnection();
        Connection other$preConnection = other.getPreConnection();
        if (this$preConnection == null ? other$preConnection != null : !this$preConnection.equals(other$preConnection)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        List<?> this$dataList = this.getDataList();
        List<?> other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        List<List<?>> this$multiDataList = this.getMultiDataList();
        List<List<?>> other$multiDataList = other.getMultiDataList();
        if (this$multiDataList == null ? other$multiDataList != null : !((Object)this$multiDataList).equals(other$multiDataList)) {
            return false;
        }
        String this$sqlCommandType = this.getSqlCommandType();
        String other$sqlCommandType = other.getSqlCommandType();
        return !(this$sqlCommandType == null ? other$sqlCommandType != null : !this$sqlCommandType.equals(other$sqlCommandType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrepSqlDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DbLinkEntity $dbLinkEntity = this.getDbLinkEntity();
        result = result * 59 + ($dbLinkEntity == null ? 43 : ((Object)$dbLinkEntity).hashCode());
        Connection $preConnection = this.getPreConnection();
        result = result * 59 + ($preConnection == null ? 43 : $preConnection.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        List<?> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        List<List<?>> $multiDataList = this.getMultiDataList();
        result = result * 59 + ($multiDataList == null ? 43 : ((Object)$multiDataList).hashCode());
        String $sqlCommandType = this.getSqlCommandType();
        result = result * 59 + ($sqlCommandType == null ? 43 : $sqlCommandType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PrepSqlDTO(dbLinkEntity=" + String.valueOf(this.getDbLinkEntity()) + ", preConnection=" + String.valueOf(this.getPreConnection()) + ", sql=" + this.getSql() + ", dataList=" + String.valueOf(this.getDataList()) + ", multiDataList=" + String.valueOf(this.getMultiDataList()) + ", sqlCommandType=" + this.getSqlCommandType() + ")";
    }

    @Generated
    public PrepSqlDTO() {
    }
}

