/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.dynamic.datasource.tx.TransactionContext;
import com.bringspring.common.database.util.ConnUtil;
import java.sql.Connection;
import java.sql.Savepoint;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MyDynamicDataSourceAutoRollbackInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Executor executor;
        Connection conn;
        boolean hasTrans = TransactionSynchronizationManager.isActualTransactionActive();
        if (!hasTrans) {
            hasTrans = StringUtils.hasText((String)TransactionContext.getXID());
        }
        Savepoint savepoint = null;
        Connection connection = null;
        if (hasTrans && (conn = (executor = (Executor)invocation.getTarget()).getTransaction().getConnection()) != null && !conn.getAutoCommit()) {
            connection = ConnUtil.getRealConnection(conn);
            try {
                savepoint = connection.setSavepoint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return invocation.proceed();
        }
        catch (Throwable e) {
            if (connection != null) {
                if (savepoint != null) {
                    connection.rollback(savepoint);
                } else {
                    connection.rollback();
                }
            }
            throw e;
        }
    }

    public Object plugin(Object target) {
        return super.plugin(target);
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
    }
}

