/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.exception.ConnectDatabaseException;
import com.bringspring.common.util.TenantHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MyDynamicRoutingDataSource
extends DynamicRoutingDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyDynamicRoutingDataSource.class);

    public MyDynamicRoutingDataSource(List<DynamicDataSourceProvider> providers) {
        super(providers);
    }

    public Connection getConnection() throws SQLException {
        String xid = TransactionContext.getXID();
        String ds = DynamicDataSourceContextHolder.peek();
        if (DynamicDataSourceUtil.isPrimaryDataSoure() && TenantHolder.isRemote()) {
            ds = TenantDataSourceUtil.getTenantAssignDataSourceMasterKeyName();
        }
        if (!StringUtils.hasText((String)xid)) {
            return this.getMyDataSource(ds);
        }
        String tKey = !StringUtils.hasText((String)ds) ? "default" : ds;
        ConnectionProxy connection = ConnectionFactory.getConnection((String)xid, (String)tKey);
        return connection == null ? this.getConnectionProxy(xid, tKey, this.getMyDataSource(ds)) : connection;
    }

    private Connection getMyDataSource(String dsKey) throws SQLException {
        try {
            DataSource dataSource = this.getDataSource(dsKey);
            Connection connection = dataSource.getConnection();
            ConnUtil.switchConnectionSchema(connection);
            return connection;
        }
        catch (SQLException e) {
            if (DynamicDataSourceUtil.containsLink(dsKey)) {
                try {
                    this.removeDataSource(dsKey);
                }
                catch (Exception ee) {
                    log.error("\u5173\u95ed\u52a8\u6001\u6570\u636e\u6e90\u3010" + dsKey + "\u3011\u5931\u8d25", (Throwable)ee);
                }
            } else if (TenantHolder.isRemote()) {
                TenantDataSourceUtil.removeAllAssignDataSource();
            }
            throw new ConnectDatabaseException(MsgCode.DB302.get(), e);
        }
    }

    private Connection getConnectionProxy(String xid, String ds, Connection connection) {
        ConnectionProxy connectionProxy = new ConnectionProxy(connection, ds);
        ConnectionFactory.putConnection((String)xid, (String)ds, (ConnectionProxy)connectionProxy);
        return connectionProxy;
    }
}

