/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.plugins.ITenantPlugin;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.TenantHolder;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MyTenantMasterSlaveAutoRoutingPlugin
implements Interceptor,
ITenantPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyTenantMasterSlaveAutoRoutingPlugin.class);
    protected DynamicRoutingDataSource dynamicDataSource;

    public MyTenantMasterSlaveAutoRoutingPlugin(DataSource dataSource) {
        this.dynamicDataSource = (DynamicRoutingDataSource)dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        if (TenantHolder.getLocalTenantCache() == null) {
            this.printNoTenant(v -> log.warn("\u672a\u8bbe\u7f6e\u79df\u6237\u4fe1\u606f, \u7981\u6b62\u67e5\u8be2\u6570\u636e\u5e93, {}, {}, {}, {}", new Object[]{v.getUserId(), v.getUrl(), v.getToken(), v.getStack()}));
            throw new DataException(MsgCode.LOG113.get());
        }
        if (!TenantHolder.getLocalTenantCache().isRemote() || !DynamicDataSourceUtil.isPrimaryDataSoure()) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        String pushedDataSource = null;
        try {
            String dataSource;
            String tenantId = Optional.ofNullable(TenantHolder.getLocalTenantCache().getEnCode()).orElse("");
            String masterKey = tenantId + "-master";
            String slaveKey = tenantId + "-slave";
            boolean hasTrans = TransactionSynchronizationManager.isActualTransactionActive();
            if (!hasTrans) {
                hasTrans = StringUtils.hasText((String)TransactionContext.getXID());
            }
            String string = dataSource = SqlCommandType.SELECT == ms.getSqlCommandType() ? slaveKey : masterKey;
            if (hasTrans || !this.dynamicDataSource.getGroupDataSources().containsKey(dataSource)) {
                dataSource = masterKey;
            }
            pushedDataSource = DynamicDataSourceContextHolder.push((String)dataSource);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (pushedDataSource != null) {
                DynamicDataSourceContextHolder.poll();
            }
        }
    }
}

