/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.append.insert;

import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbMySQL;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.sql.impl.SqlOracle;
import java.util.List;
import lombok.Generated;

public class InsertSqlDTO {
    private DbBase dbBase;
    private String table;
    private List<List<DbFieldMod>> dataList;
    private String batchInsertSeparator;

    public InsertSqlDTO(DbBase dbBase, String table, List<List<DbFieldMod>> dataList, String batchInsertSeparator) {
        this.dbBase = dbBase;
        this.table = table;
        this.dataList = dataList;
        this.batchInsertSeparator = batchInsertSeparator;
    }

    public String getFieldValue(String fieldTypeName, String fieldValue) {
        if (this.dbBase.getClass() == DbOracle.class) {
            return SqlOracle.getOracleDataTime(fieldTypeName, fieldValue);
        }
        if (null == fieldValue) {
            return fieldValue + ",";
        }
        return "'" + fieldValue + "',";
    }

    public String getOracleInsertBasicSql() {
        if (this.dbBase.getClass() == DbOracle.class) {
            return "INSERT INTO " + this.table + " VALUES";
        }
        return "";
    }

    public String getMysqlInsertBasicSql() {
        if (this.dbBase.getClass() == DbMySQL.class) {
            return "INSERT INTO " + this.table + " VALUES";
        }
        return "";
    }

    @Generated
    public DbBase getDbBase() {
        return this.dbBase;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public List<List<DbFieldMod>> getDataList() {
        return this.dataList;
    }

    @Generated
    public String getBatchInsertSeparator() {
        return this.batchInsertSeparator;
    }

    @Generated
    public void setDbBase(DbBase dbBase) {
        this.dbBase = dbBase;
    }

    @Generated
    public void setTable(String table) {
        this.table = table;
    }

    @Generated
    public void setDataList(List<List<DbFieldMod>> dataList) {
        this.dataList = dataList;
    }

    @Generated
    public void setBatchInsertSeparator(String batchInsertSeparator) {
        this.batchInsertSeparator = batchInsertSeparator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertSqlDTO)) {
            return false;
        }
        InsertSqlDTO other = (InsertSqlDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DbBase this$dbBase = this.getDbBase();
        DbBase other$dbBase = other.getDbBase();
        if (this$dbBase == null ? other$dbBase != null : !((Object)this$dbBase).equals(other$dbBase)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<List<DbFieldMod>> this$dataList = this.getDataList();
        List<List<DbFieldMod>> other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        String this$batchInsertSeparator = this.getBatchInsertSeparator();
        String other$batchInsertSeparator = other.getBatchInsertSeparator();
        return !(this$batchInsertSeparator == null ? other$batchInsertSeparator != null : !this$batchInsertSeparator.equals(other$batchInsertSeparator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InsertSqlDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DbBase $dbBase = this.getDbBase();
        result = result * 59 + ($dbBase == null ? 43 : ((Object)$dbBase).hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<List<DbFieldMod>> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        String $batchInsertSeparator = this.getBatchInsertSeparator();
        result = result * 59 + ($batchInsertSeparator == null ? 43 : $batchInsertSeparator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InsertSqlDTO(dbBase=" + String.valueOf(this.getDbBase()) + ", table=" + this.getTable() + ", dataList=" + String.valueOf(this.getDataList()) + ", batchInsertSeparator=" + this.getBatchInsertSeparator() + ")";
    }
}

