/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.impl;

import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class SqlSQLServer
extends SqlBase {
    private final String dbTimeSql = "Select CONVERT(varchar(100), GETDATE(), 120) as TIME";
    protected String deleteSql = "DROP TABLE ?;";
    protected String renameSql = "EXEC sp_rename '?', '?';";

    @Override
    protected void init() {
        String fieldListSql = "SELECT cast(a.name as varchar(50)) FIELD_NAME , cast(case when exists(SELECT 1 FROM sysobjects where xtype='PK' and name in (  SELECT name FROM sysindexes WHERE indid in(  SELECT indid FROM sysindexkeys WHERE id = a.id AND colid=a.colid )))  then '1' else '0' end as varchar(50)) PRIMARY_KEY,  cast(b.name as varchar(50)) DATATYPE,  cast(COLUMNPROPERTY(a.id,a.name,'PRECISION') as varchar(50)) DATA_LENGTH,  cast(case when a.isnullable=0 then '0'else '1' end as varchar(50)) ALLOW_NULL,  cast(isnull(e.text,'') as varchar(50)) DEFAULTS,  cast(isnull(g.[value],'') as varchar(50)) FIELD_COMMENT\nFROM syscolumns a left join systypes b on a.xusertype=b.xusertype inner join sysobjects d on a.id=d.id and d.xtype='U' and d.name<>'dtproperties' left join syscomments e on a.cdefault=e.id left join sys.extended_properties g on a.id=g.major_id and a.colid=g.minor_id left join sys.extended_properties f on d.id=f.major_id and f.minor_id=0 where d.name = " + ParamEnum.DB_NAME.getParamSign() + "\norder by a.id,a.colorder";
        String tableListSql = "SET NOCOUNT ON DECLARE @TABLEINFO TABLE ( NAME VARCHAR(50) , SUMROWS VARCHAR(11) , RESERVED VARCHAR(50) , DATA VARCHAR(50) , INDEX_SIZE VARCHAR(50) , UNUSED VARCHAR(50) , PK VARCHAR(50) ) DECLARE @TABLENAME TABLE ( NAME VARCHAR(50) ) DECLARE @NAME VARCHAR(50) DECLARE @PK VARCHAR(50) INSERT INTO @TABLENAME ( NAME ) SELECT O.NAME FROM SYSOBJECTS O , SYSINDEXES I WHERE O.ID = I.ID AND O.XTYPE = 'U' AND I.INDID < 2 ORDER BY I.ROWS DESC , O.NAME WHILE EXISTS ( SELECT 1 FROM @TABLENAME ) BEGIN SELECT TOP 1 @NAME = NAME FROM @TABLENAME DELETE @TABLENAME WHERE NAME = @NAME DECLARE @OBJECT_ID INT SET @OBJECT_ID = OBJECT_ID(@NAME) SELECT @PK = COL_NAME(@OBJECT_ID, COLID) FROM SYSOBJECTS AS O INNER JOIN SYSINDEXES AS I ON I.NAME = O.NAME INNER JOIN SYSINDEXKEYS AS K ON K.INDID = I.INDID WHERE O.XTYPE = 'PK' AND PARENT_OBJ = @OBJECT_ID AND K.ID = @OBJECT_ID INSERT INTO @TABLEINFO ( NAME , SUMROWS , RESERVED , DATA , INDEX_SIZE , UNUSED ) EXEC SYS.SP_SPACEUSED @NAME UPDATE @TABLEINFO SET PK = @PK WHERE NAME = @NAME END SELECT cast(F.NAME AS varchar(50))TABLE_NAME,cast(ISNULL( P.TDESCRIPTION, F.NAME )  AS varchar(50)) TABLE_COMMENT,cast(F.RESERVED AS varchar(50)) SIZE,cast(RTRIM( F.SUMROWS ) AS varchar(50)) TABLE_SUM,cast(F.PK AS varchar(50)) PRIMARYKEY FROM @TABLEINFO F LEFT JOIN ( SELECT NAME = CASE WHEN A.COLORDER = 1 THEN D.NAME ELSE '' END , TDESCRIPTION = CASE WHEN A.COLORDER = 1 THEN ISNULL(F.VALUE, '') ELSE '' END FROM SYSCOLUMNS A LEFT JOIN SYSTYPES B ON A.XUSERTYPE = B.XUSERTYPE INNER JOIN SYSOBJECTS D ON A.ID = D.ID AND D.XTYPE = 'U' AND D.NAME <> 'DTPROPERTIES' LEFT JOIN SYS.EXTENDED_PROPERTIES F ON D.ID = F.MAJOR_ID WHERE A.COLORDER = 1 AND F.MINOR_ID = 0 ) P ON F.NAME = P.NAME WHERE 1 = 1 ORDER BY TABLE_NAME";
        String existsTableSql = "SELECT table_name FROM INFORMATION_SCHEMA.TABLES where table_type = 'BASE TABLE' and TABLE_NAME = " + ParamEnum.TABLE.getParamSign() + ";";
        this.setInstance(fieldListSql, tableListSql, existsTableSql, "{table}:", "", "{table}");
    }

    @Override
    public String[] getPageSql(String sql, String sortType, Integer currentPage, Integer pageSize) {
        Object sortSql = StringUtils.isEmpty(sortType) ? "" : " ORDER BY " + sortType;
        int startIndex = currentPage - 1;
        String dataListSql = sql + (String)sortSql + " offset " + startIndex * pageSize + " rows fetch next " + pageSize + " rows only;";
        String totalSql = "SELECT COUNT(*) totalRecord FROM (" + sql + ") jsbos_tab;";
        return new String[]{dataListSql, totalSql};
    }

    private String getTotalSql(String sql) {
        int selectStar = sql.indexOf("SELECT");
        int fromEnd = sql.indexOf("FROM");
        return sql.substring(0, selectStar + 6) + " COUNT(*) AS totalRecord " + sql.substring(fromEnd);
    }

    public static List<PreparedStatementDTO> getTableComment(String tableComment, String newTableName, List<DbTableFieldModel> models) {
        ArrayList<PreparedStatementDTO> PSDs = new ArrayList<PreparedStatementDTO>();
        PSDs.add(SqlSQLServer.insertTableCommentPSD(tableComment, "dbo", newTableName));
        for (DbTableFieldModel model : models) {
            PSDs.add(SqlSQLServer.insertFieldCommentPSD(model.getFieldName(), "dbo", newTableName, model.getField()));
        }
        return PSDs;
    }

    private static PreparedStatementDTO insertTableCommentPSD(String comment, String schema, String table) {
        String preparedSql = "EXEC sp_addextendedproperty 'MS_Description',N'" + comment + "','SCHEMA',N'" + schema + "','TABLE',N'" + table + "';";
        return new PreparedStatementDTO(null, preparedSql);
    }

    private static PreparedStatementDTO insertFieldCommentPSD(String comment, String schema, String table, String column) {
        String preparedSql = "EXEC sp_addextendedproperty 'MS_Description',N'" + comment + "','SCHEMA',N'" + schema + "','TABLE',N'" + table + "','COLUMN',N'" + column + "';";
        return new PreparedStatementDTO(null, preparedSql);
    }

    @Generated
    public String getDbTimeSql() {
        return this.dbTimeSql;
    }

    @Override
    @Generated
    public String getDeleteSql() {
        return this.deleteSql;
    }

    @Generated
    public String getRenameSql() {
        return this.renameSql;
    }

    @Override
    @Generated
    public void setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
    }

    @Generated
    public void setRenameSql(String renameSql) {
        this.renameSql = renameSql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlSQLServer)) {
            return false;
        }
        SqlSQLServer other = (SqlSQLServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbTimeSql = this.getDbTimeSql();
        String other$dbTimeSql = other.getDbTimeSql();
        if (this$dbTimeSql == null ? other$dbTimeSql != null : !this$dbTimeSql.equals(other$dbTimeSql)) {
            return false;
        }
        String this$deleteSql = this.getDeleteSql();
        String other$deleteSql = other.getDeleteSql();
        if (this$deleteSql == null ? other$deleteSql != null : !this$deleteSql.equals(other$deleteSql)) {
            return false;
        }
        String this$renameSql = this.getRenameSql();
        String other$renameSql = other.getRenameSql();
        return !(this$renameSql == null ? other$renameSql != null : !this$renameSql.equals(other$renameSql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SqlSQLServer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbTimeSql = this.getDbTimeSql();
        result = result * 59 + ($dbTimeSql == null ? 43 : $dbTimeSql.hashCode());
        String $deleteSql = this.getDeleteSql();
        result = result * 59 + ($deleteSql == null ? 43 : $deleteSql.hashCode());
        String $renameSql = this.getRenameSql();
        result = result * 59 + ($renameSql == null ? 43 : $renameSql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SqlSQLServer(dbTimeSql=" + this.getDbTimeSql() + ", deleteSql=" + this.getDeleteSql() + ", renameSql=" + this.getRenameSql() + ")";
    }
}

