/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.bringspring.common.database.model.dto.PrepSqlDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.DynamicDataSourceUtil;
import com.bringspring.common.database.util.TenantDataSourceUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnUtil.class);

    public static Connection getConnOrDefault(DbSourceOrDbLink dbSourceOrDbLink) throws DataException {
        if (dbSourceOrDbLink == null) {
            dbSourceOrDbLink = DynamicDataSourceUtil.getDataSourceUtil();
        }
        return PrepSqlDTO.getConn(dbSourceOrDbLink.init());
    }

    public static Connection getConn(DbSourceOrDbLink dbSourceOrDbLink) throws DataException {
        return PrepSqlDTO.getConn(dbSourceOrDbLink.init());
    }

    public static Connection getConn(DbSourceOrDbLink dbSourceOrDbLink, String dbName) throws DataException {
        return PrepSqlDTO.getConn(dbSourceOrDbLink.init(dbName));
    }

    public static Connection getConn(String userName, String password, String url) throws DataException {
        DbLinkEntity dbLinkEntity = new DbLinkEntity();
        dbLinkEntity.setUserName(userName);
        dbLinkEntity.setPassword(password);
        dbLinkEntity.setUrl(url);
        dbLinkEntity.setDbType(DbTypeUtil.getDb(url).getDbEncode());
        return PrepSqlDTO.getConn(dbLinkEntity);
    }

    @Deprecated
    private static Connection getConnection(DbSourceOrDbLink dbSourceOrDbLink) throws DataException {
        return ConnUtil.getConnection(dbSourceOrDbLink, null);
    }

    @Deprecated
    private static Connection getConnection(DbSourceOrDbLink dataSourceUtil, String dbName) throws DataException {
        DbLinkEntity dbLinkEntity = dataSourceUtil.init();
        if (DbTypeUtil.checkOracle(dbLinkEntity).booleanValue()) {
            return ConnUtil.getOracleConn(dbLinkEntity);
        }
        return ConnUtil.getConnection(dbLinkEntity.getAutoUsername(), dbLinkEntity.getAutoPassword(), ConnUtil.getUrl(dbLinkEntity));
    }

    @Deprecated
    private static Connection getConnection(String userName, String password, String url) throws DataException {
        DbBase db = DbTypeUtil.getDb(url);
        return ConnCommon.createConn(db.getDriver(), userName, password, url);
    }

    private static Connection getOracleConn(DbLinkEntity dsd) throws DataException {
        DbOracle dbOracle = new DbOracle();
        return dbOracle.getOracleConn(dsd, ConnUtil.getUrl(dsd));
    }

    public static String getUrl(DbSourceOrDbLink dbSourceOrDbLink) {
        return ConnUtil.getUrl(dbSourceOrDbLink, null);
    }

    public static String getUrl(DbSourceOrDbLink dbSourceOrDbLink, String dbName) {
        return DbBase.BaseCommon.getDbBaseConnUrl(dbSourceOrDbLink, dbName);
    }

    public static void switchConnectionSchema(Connection conn) throws SQLException {
        String schema;
        if (TenantDataSourceUtil.isMultiTenancy() && DynamicDataSourceUtil.isPrimaryDataSoure() && TenantHolder.getLocalTenantCache() != null && StringUtils.isNotEmpty(schema = TenantDataSourceUtil.getTenantDbName())) {
            Connection tmpConnection = ConnUtil.getRealConnection(conn);
            try {
                switch (DynamicDataSourceUtil.getPrimaryDbType()) {
                    case "SQLServer": 
                    case "MySQL": {
                        if (!Objects.equals(tmpConnection.getCatalog(), schema)) {
                            tmpConnection.setCatalog(schema);
                        }
                        break;
                    }
                    case "PostgreSQL": {
                        schema = schema.toLowerCase();
                        if (!Objects.equals(tmpConnection.getSchema(), schema)) {
                            tmpConnection.setSchema(schema);
                        }
                        break;
                    }
                    case "Oracle": {
                        schema = schema.toUpperCase();
                        if (!Objects.equals(tmpConnection.getSchema(), schema)) {
                            tmpConnection.setSchema(schema);
                        }
                        break;
                    }
                    default: {
                        if (!Objects.equals(tmpConnection.getSchema(), schema)) {
                            tmpConnection.setSchema(schema);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                conn.close();
                String url = "";
                if (tmpConnection instanceof ConnectionProxy) {
                    try {
                        url = ((ConnectionProxy)tmpConnection).getDirectDataSource().getUrl();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                log.error("\u5207\u5e93\u5931\u8d25, \u79df\u6237\uff1a{}, URL: {}, Msg: {}", new Object[]{TenantHolder.getDatasourceId(), url, e.getMessage()});
                throw e;
            }
        }
    }

    public static String getConnectionDbName(Connection conn) throws SQLException {
        String dbCode;
        Connection tmpConnection = ConnUtil.getRealConnection(conn);
        return switch (dbCode = DbTypeUtil.getDb(tmpConnection.getMetaData().getURL()).getDbEncode()) {
            case "Oracle", "DM8" -> tmpConnection.getSchema();
            default -> tmpConnection.getCatalog();
        };
    }

    public static String getConnectionSchema(Connection conn) throws SQLException {
        String dbCode;
        Connection tmpConnection = ConnUtil.getRealConnection(conn);
        return switch (dbCode = DbTypeUtil.getDb(tmpConnection.getMetaData().getURL()).getDbEncode()) {
            case "Oracle", "DM8", "PostgreSQL", "KingbaseES", "SQLServer" -> tmpConnection.getSchema();
            default -> tmpConnection.getCatalog();
        };
    }

    public static Connection getRealConnection(Connection connection) {
        Connection tmpConnection = connection;
        for (int i = 0; i < 6; ++i) {
            try {
                tmpConnection = (Connection)ReflectUtil.invoke((Object)tmpConnection, (String)"getConnection", (Object[])new Object[0]);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return tmpConnection;
    }

    public static DruidDataSource getDruidDataSource(DataSourceUtil dataSourceUtil) throws DataException {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUsername(dataSourceUtil.getUserName());
        druidDataSource.setPassword(dataSourceUtil.getPassword());
        druidDataSource.setUrl(ConnUtil.getUrl(dataSourceUtil));
        druidDataSource.setDriverClassName(DbTypeUtil.getDb(dataSourceUtil).getDriver());
        return druidDataSource;
    }

    public static class ConnCommon {
        public static Connection createConn(String driver, String userName, String password, String url) throws DataException {
            try {
                Class.forName(driver);
                return DriverManager.getConnection(url, userName, password);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw DataException.errorLink(e.getMessage());
            }
        }

        public static Connection createConnByProp(String driver, String userName, String password, String url, Properties conProps) throws DataException {
            try {
                conProps.put("user", userName);
                conProps.put("password", password);
                Class.forName(driver);
                return DriverManager.getConnection(url, conProps);
            }
            catch (Exception e) {
                throw new DataException(e.getMessage());
            }
        }

        public static Connection getConnRemarks(DataSourceUtil dbSourceOrDbLink) throws DataException {
            Properties props = new Properties();
            props.setProperty("remarks", "true");
            props.setProperty("remarksReporting", "true");
            props.setProperty("useInformationSchema", "true");
            return ConnCommon.createConnByProp(DbTypeUtil.getDb(ConnUtil.getUrl(dbSourceOrDbLink)).getDriver(), dbSourceOrDbLink.getUserName(), dbSourceOrDbLink.getPassword(), ConnUtil.getUrl(dbSourceOrDbLink), props);
        }
    }
}

