/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.properties;

import java.util.ArrayList;
import java.util.List;

public class GatewayWhite {
    public static final String PREFIX = "gateway";
    public List<String> excludeUrl = new ArrayList<String>();
    public List<String> whiteUrl = new ArrayList<String>();
    public List<String> blockUrl = new ArrayList<String>();
    public List<String> whiteIp = new ArrayList<String>();

    public GatewayWhite() {
        this.interceptPath();
        this.whitePath();
        this.excludePath();
        this.whiteIp();
    }

    public List<String> getWhiteUrl() {
        return new ArrayList<String>(this.whiteUrl);
    }

    public List<String> getBlockUrl() {
        return new ArrayList<String>(this.blockUrl);
    }

    public List<String> getExcludeUrl() {
        return new ArrayList<String>(this.excludeUrl);
    }

    public List<String> getWhiteIp() {
        return new ArrayList<String>(this.whiteIp);
    }

    public void setWhiteUrl(List<String> whiteUrl) {
        this.whitePath();
        this.whiteUrl.addAll(whiteUrl);
    }

    public void setBlockUrl(List<String> blockUrl) {
        this.interceptPath();
        this.blockUrl.addAll(blockUrl);
    }

    public void setExcludeUrl(List<String> excludeUrl) {
        this.excludePath();
        this.excludeUrl.addAll(excludeUrl);
    }

    public void setWhiteIp(List<String> whiteIp) {
        this.whiteIp();
        this.whiteIp.addAll(whiteIp);
    }

    protected void interceptPath() {
        this.blockUrl.clear();
        this.blockUrl.add("/actuator/**");
        this.blockUrl.add("/api/*/actuator/**");
        this.blockUrl.add("/doc.html");
        this.blockUrl.add("/swagger-resources/**");
        this.blockUrl.add("/swagger-ui/**");
        this.blockUrl.add("/api/*/v?/api-docs/**");
        this.blockUrl.add("/v?/api-docs/**");
    }

    protected void whitePath() {
        this.whiteUrl.clear();
        this.whiteUrl.add("/api/oauth/Login/**");
        this.whiteUrl.add("/api/oauth/Logout/**");
        this.whiteUrl.add("/api/oauth/resetOfficialPassword/**");
        this.whiteUrl.add("/api/oauth/codeCertificate");
        this.whiteUrl.add("/api/oauth/codeCertificateStatus/*");
        this.whiteUrl.add("/api/oauth/LogingByQy");
        this.whiteUrl.add("/api/oauth/getUserIdByCode");
        this.whiteUrl.add("/api/oauth/getFile");
        this.whiteUrl.add("/api/oauth/register");
        this.whiteUrl.add("/api/oauth/SmsCode/**");
        this.whiteUrl.add("/api/oauth/getQyhConfig");
        this.whiteUrl.add("/api/oauth/getSystemAddress/{terminal}");
        this.whiteUrl.add("/api/app/Version");
        this.whiteUrl.add("/api/message/websocket/*");
        this.whiteUrl.add("/message/websocket");
        this.whiteUrl.add("/api/file/VisusalImg/**");
        this.whiteUrl.add("/api/blade-visual/map/data");
        this.whiteUrl.add("/api/blade-visual/category/list");
        this.whiteUrl.add("/api/blade-visual/visual/put-file/**");
        this.whiteUrl.add("/api/visualdev/DataScreen/Images/**");
        this.whiteUrl.add("/api/system/DataMap/**");
        this.whiteUrl.add("/api/system/DataMap/{id}/Data");
        this.whiteUrl.add("/api/visualdev/Generater/DownloadVisCode");
        this.whiteUrl.add("/api/visualdev/Generater/DownloadVisCode/**");
        this.whiteUrl.add("/api/tenant/DbName/**");
        this.whiteUrl.add("/api/tenant/login");
        this.whiteUrl.add("/api/tenant/logout");
        this.whiteUrl.add("/api/Report/data/Download");
        this.whiteUrl.add("/api/extend/DocumentPreview/**");
        this.whiteUrl.add("/api/extend/Document/getShareEntityById/{id}");
        this.whiteUrl.add("/api/extend/DocumentPreview/down/{fileName}");
        this.whiteUrl.add("/api/file/VisusalImg/**");
        this.whiteUrl.add("/api/file/AppStartInfo/*");
        this.whiteUrl.add("/api/file/Image/**");
        this.whiteUrl.add("/api/file/Download");
        this.whiteUrl.add("/api/file/ImageCode/**");
        this.whiteUrl.add("/api/file/Uploader/**");
        this.whiteUrl.add("/api/file/DownloadModel/**");
        this.whiteUrl.add("/api/system/DictionaryData/*/Data/Selector");
        this.whiteUrl.add("/api/system/DictionaryData/{dictionaryTypeId}/Data/Selector");
        this.whiteUrl.add("/api/datareport/pdf/show");
        this.whiteUrl.add("/api/datareport/preview/loadPagePaper");
        this.whiteUrl.add("/api/datareport/pdf");
        this.whiteUrl.add("/api/datareport/word");
        this.whiteUrl.add("/api/datareport/excel/**");
        this.whiteUrl.add("/api/datareport/Data/*/Actions/Export");
        this.whiteUrl.add("/api/datareport/import");
        this.whiteUrl.add("/api/system/DataInterface/*/Actions/Response");
        this.whiteUrl.add("/api/system/DataInterface/{id}/Actions/Response");
        this.whiteUrl.add("/api/system/DataInterface/Actions/GetAuth");
        this.whiteUrl.add("/doc.html");
        this.whiteUrl.add("/webjars/**");
        this.whiteUrl.add("/api/*/v?/api-docs/**");
        this.whiteUrl.add("/v?/api-docs/**");
        this.whiteUrl.add("/swagger-ui/**");
        this.whiteUrl.add("/swagger-resources/**");
        this.whiteUrl.add("/v3/**");
        this.whiteUrl.add("/csrf");
        this.whiteUrl.add("/api/oauth/ImageCode/**");
        this.whiteUrl.add("/api/oauth/ImageCode/{codeLength}/{timestamp}");
        this.whiteUrl.add("/api/oauth/getConfig/*");
        this.whiteUrl.add("/api/oauth/getConfig/{account}");
        this.whiteUrl.add("/api/oauth/getLoginConfig");
        this.whiteUrl.add("/api/oauth/getTicketStatus/*");
        this.whiteUrl.add("/api/oauth/getTicket");
        this.whiteUrl.add("/api/oauth/setCodeCertificateStatus/{ticket}/{status}");
        this.whiteUrl.add("/api/message/ShortLink/**");
        this.whiteUrl.add("/api/message/WechatOpen/token/**");
        this.whiteUrl.add("/api/visualdev/ShortLink/**");
        this.whiteUrl.add("/api/visualdev/Hooks/*");
        this.whiteUrl.add("/api/visualdev/Hooks/*/params/*");
        this.whiteUrl.add("/api/workflow/Hooks/*");
        this.whiteUrl.add("/api/workflow/task/Hooks");
        this.whiteUrl.add("/api/workflow/Hooks/*/params/*");
        this.whiteUrl.add("/api/system/Location/*");
        this.whiteUrl.add("/api/*/white/**");
        this.whiteUrl.add("/api/*/*/white/**");
        this.whiteUrl.add("/api/service/**");
        this.whiteUrl.add("/api/white/**");
        this.whiteUrl.add("/api/system/Menu/systemList");
        this.whiteUrl.add("/web/**");
        this.whiteUrl.add("/mobile/**");
        this.whiteUrl.add("/static/**");
        this.whiteUrl.add("/cdn/**");
        this.whiteUrl.add("/*.icon");
        this.whiteUrl.add("/*.js");
        this.whiteUrl.add("/index.html");
        this.whiteUrl.add("/");
    }

    protected void excludePath() {
        this.excludeUrl.clear();
        this.excludeUrl.add("/favicon.ico");
        this.excludeUrl.add("/api/message/websocket/*");
        this.excludeUrl.add("/message/websocket");
    }

    protected void whiteIp() {
        this.whiteIp.clear();
        this.whiteIp.add("127.0.0.1");
    }
}

