/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.encrypt;

import cn.hutool.core.util.HexUtil;
import com.bringspring.common.annotation.EncryptApi;
import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.util.DesUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponseAdvice
implements ResponseBodyAdvice<Object> {
    private ObjectMapper objectMapper;

    public EncryptResponseAdvice(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        EncryptApi methodAnnotation = (EncryptApi)returnType.getMethodAnnotation(EncryptApi.class);
        return methodAnnotation != null && methodAnnotation.encryptResponse();
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            byte[] bytes = this.objectMapper.writeValueAsBytes(body);
            return HexUtil.encodeHexStr((byte[])DesUtil.aesOrDecode(bytes, true, true, SecurityProperties.getInstance().getSecurityKey()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

