/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.permissions;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.TenantProvider;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.TenantHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionInterfaceImpl
implements StpInterface {
    public static final String PERMISSION_KEY = "user_permission";
    public static final String ROLE_KEY = "user_roles";
    public static final String COLUMN_KEY = "user_columns";
    public static final String FORM_KEY = "user_forms";
    public static final String OTHER_PERMISSION = "permission:";
    public static final String USER_AUTH = "user_auth";
    @Autowired
    private SecurityProperties securityProperties;

    public List<String> getPermissionList(Object loginId, String loginType) {
        if (!this.securityProperties.isEnablePreAuth()) {
            return Collections.emptyList();
        }
        return PermissionInterfaceImpl.getListByType(PERMISSION_KEY);
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        if (!this.securityProperties.isEnablePreAuth()) {
            return Collections.emptyList();
        }
        return PermissionInterfaceImpl.getListByType(ROLE_KEY);
    }

    public static Map<String, Object> getColumnMap() {
        return PermissionInterfaceImpl.getMapByType(COLUMN_KEY);
    }

    public static Map<String, Object> getFormMap() {
        return PermissionInterfaceImpl.getMapByType(FORM_KEY);
    }

    public static void setMap(String userAccount, String sysId, Map<String, List<Map<String, Object>>> columnsMap, Map<String, List<Map<String, Object>>> formMap) {
        userAccount = UserProvider.splicingLoginId(userAccount);
        String tenantId = TenantHolder.getDatasourceId();
        Map<String, Object> map = PermissionInterfaceImpl.getMap();
        HashMap<String, Object> mapRes = new HashMap<String, Object>(map);
        Map<String, Map<String, List<Map<String, Object>>>> mapAuth = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        if (map.containsKey(sysId)) {
            mapAuth = (Map)map.get(sysId);
        }
        if (!columnsMap.isEmpty()) {
            mapAuth.put(COLUMN_KEY, columnsMap);
        }
        if (!formMap.isEmpty()) {
            mapAuth.put(FORM_KEY, formMap);
        }
        mapRes.put(sysId, mapAuth);
        SaManager.getSaTokenDao().set(OTHER_PERMISSION + tenantId + "_" + userAccount, JSONObject.toJSONString(mapRes), 86400L);
    }

    public static Map<String, Object> getMap() {
        UserInfo userInfo = UserProvider.getUser();
        String account = userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserId();
        account = UserProvider.splicingLoginId(account);
        String tenantId = TenantHolder.getDatasourceId();
        String json = SaManager.getSaTokenDao().get(OTHER_PERMISSION + tenantId + "_" + account);
        if (StringUtils.isEmpty(json)) {
            return Collections.emptyMap();
        }
        return JSONObject.parseObject((String)json);
    }

    private static Map<String, Object> getMapByType(String typeKey) {
        Map<String, Object> map = PermissionInterfaceImpl.getMap();
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            Map obj = (Map)map.get(key);
            if (obj == null || !obj.containsKey(typeKey)) continue;
            res.putAll((Map)obj.get(typeKey));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserAuth(String userAccount, String sysId, Set<String> authorityList, Set<String> roleAuthorityList, BaseSystemInfo baseSystemInfo) {
        userAccount = UserProvider.splicingLoginId(userAccount);
        try {
            TenantProvider.setBaseSystemInfo(baseSystemInfo);
            Map<String, Object> map = PermissionInterfaceImpl.getUserAuth();
            HashMap<String, Object> mapRes = new HashMap<String, Object>(map);
            Map<String, Set<String>> mapAuth = new HashMap<String, Set<String>>();
            if (map.containsKey(sysId)) {
                mapAuth = (Map)map.get(sysId);
            }
            if (!authorityList.isEmpty()) {
                mapAuth.put(PERMISSION_KEY, authorityList);
            }
            if (!roleAuthorityList.isEmpty()) {
                mapAuth.put(ROLE_KEY, roleAuthorityList);
            }
            mapRes.put(sysId, mapAuth);
            StpUtil.getSessionByLoginId((Object)userAccount, (boolean)true).set(USER_AUTH, mapRes);
        }
        finally {
            TenantProvider.clearBaseSystemIfo();
        }
    }

    public static Map<String, Object> getUserAuth() {
        UserInfo userInfo = UserProvider.getUser();
        String account = userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserId();
        SaSession saSession = StpUtil.getSessionByLoginId((Object)(account = UserProvider.splicingLoginId(account)), (boolean)false);
        if (saSession == null) {
            return Collections.emptyMap();
        }
        return (Map)saSession.get(USER_AUTH, Collections.emptyMap());
    }

    private static List<String> getListByType(String typeKey) {
        Map<String, Object> userAuth = PermissionInterfaceImpl.getUserAuth();
        ArrayList<String> list = new ArrayList<String>();
        if (userAuth != null) {
            for (String key : userAuth.keySet()) {
                Map obj = (Map)userAuth.get(key);
                if (obj == null || !obj.containsKey(typeKey)) continue;
                list.addAll((Set)obj.get(typeKey));
            }
        }
        return list;
    }
}

