/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.wrapper;

import com.bringspring.common.constant.GlobalConst;
import com.bringspring.common.security.handler.IRestHandler;
import com.bringspring.common.util.StringUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MyResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream buffer;
    private ServletOutputStream out = null;
    private PrintWriter writer = null;
    private List<IRestHandler> handlers;
    private boolean supportResponse;

    public MyResponseWrapper(HttpServletResponse resp, List<IRestHandler> handlers) throws IOException {
        super(resp);
        this.handlers = handlers.stream().filter(IRestHandler::supportResponse).collect(Collectors.toList());
        this.supportResponse = !this.handlers.isEmpty();
        Collections.reverse(this.handlers);
        if (this.supportResponse) {
            this.buffer = new ByteArrayOutputStream();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.supportResponse) {
            if (this.out == null) {
                this.out = new WapperedOutputStream(this, this.buffer);
            }
            return this.out;
        }
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.supportResponse) {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, this.getCharacterEncoding()));
            }
            return this.writer;
        }
        return super.getWriter();
    }

    public void flushBuffer() throws IOException {
        if (this.supportResponse) {
            if (this.out != null) {
                this.out.flush();
            }
            if (this.writer != null) {
                this.writer.flush();
            }
        } else {
            super.flushBuffer();
        }
    }

    public void reset() {
        if (this.supportResponse) {
            this.buffer.reset();
        } else {
            super.reset();
        }
    }

    public void doFinal() throws IOException {
        if (this.supportResponse) {
            this.flushBuffer();
            if (this.buffer.size() > 0) {
                byte[] byteArray = this.buffer.toByteArray();
                if (this.supportResponse && this.isJsonBodyRequest()) {
                    this.getResponse().setContentLength(-1);
                    this.getResponse().setCharacterEncoding(GlobalConst.DEFAULT_CHARSET_STR);
                    String data = new String(byteArray, GlobalConst.DEFAULT_CHARSET);
                    for (IRestHandler handler : this.handlers) {
                        data = handler.processResponse(data);
                    }
                    this.writeResponse(data);
                    return;
                }
                this.writeResponse(byteArray);
            }
        }
    }

    private void writeResponse(String responseString) throws IOException {
        PrintWriter out = this.getResponse().getWriter();
        out.write(responseString);
        out.flush();
        out.close();
    }

    private void writeResponse(byte[] responseData) throws IOException {
        ServletOutputStream outputStream = this.getResponse().getOutputStream();
        outputStream.write(responseData);
        outputStream.flush();
        outputStream.close();
    }

    protected boolean isJsonBodyRequest() {
        String contentType = this.getResponse().getContentType();
        return StringUtils.isNotEmpty(contentType) && org.springframework.util.StringUtils.substringMatch((CharSequence)contentType, (int)0, (CharSequence)"application/json");
    }

    private class WapperedOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream bos = null;

        public WapperedOutputStream(MyResponseWrapper myResponseWrapper, ByteArrayOutputStream stream) throws IOException {
            this.bos = stream;
        }

        public void write(int b) throws IOException {
            this.bos.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener listener) {
        }
    }
}

