/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.entity.FileDownLogEntity;
import com.bringspring.common.mapper.FileDownLogMapper;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.model.filedownlog.FileDownLogPagination;
import com.bringspring.common.model.filedownlog.FileDownLogUpForm;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileDownLogServiceImpl
extends ServiceImpl<FileDownLogMapper, FileDownLogEntity>
implements FileDownLogService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<FileDownLogEntity> getList(FileDownLogPagination filedownlogPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int filedownlogNum = 0;
        QueryWrapper filedownlogQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_id())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileId, (Object)filedownlogPagination.getFile_id());
        }
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_name())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileName, (Object)filedownlogPagination.getFile_name());
        }
        if (StringUtils.isNotEmpty(filedownlogPagination.getStorage_path())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getStoragePath, (Object)filedownlogPagination.getStorage_path());
        }
        if (AllIdList.size() > 0) {
            filedownlogQueryWrapper.lambda().in(FileDownLogEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty(filedownlogPagination.getSidx())) {
            filedownlogQueryWrapper.lambda().orderByDesc(FileDownLogEntity::getId);
        } else {
            try {
                String sidx = filedownlogPagination.getSidx();
                FileDownLogEntity filedownlogEntity = new FileDownLogEntity();
                Field declaredField = filedownlogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                filedownlogQueryWrapper = "asc".equalsIgnoreCase(filedownlogPagination.getSort()) ? (QueryWrapper)filedownlogQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)filedownlogQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(filedownlogPagination.getCurrentPage(), filedownlogPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)filedownlogQueryWrapper);
            return filedownlogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return filedownlogPagination.setData(list, list.size());
    }

    @Override
    public List<FileDownLogEntity> getTypeList(FileDownLogPagination filedownlogPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int filedownlogNum = 0;
        QueryWrapper filedownlogQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_id())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileId, (Object)filedownlogPagination.getFile_id());
        }
        if (StringUtils.isNotEmpty(filedownlogPagination.getFile_name())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getFileName, (Object)filedownlogPagination.getFile_name());
        }
        if (StringUtils.isNotEmpty(filedownlogPagination.getStorage_path())) {
            ++filedownlogNum;
            filedownlogQueryWrapper.lambda().like(FileDownLogEntity::getStoragePath, (Object)filedownlogPagination.getStorage_path());
        }
        if (AllIdList.size() > 0) {
            filedownlogQueryWrapper.lambda().in(FileDownLogEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty(filedownlogPagination.getSidx())) {
            filedownlogQueryWrapper.lambda().orderByDesc(FileDownLogEntity::getId);
        } else {
            try {
                String sidx = filedownlogPagination.getSidx();
                FileDownLogEntity filedownlogEntity = new FileDownLogEntity();
                Field declaredField = filedownlogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                filedownlogQueryWrapper = "asc".equalsIgnoreCase(filedownlogPagination.getSort()) ? (QueryWrapper)filedownlogQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)filedownlogQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(filedownlogPagination.getCurrentPage(), filedownlogPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)filedownlogQueryWrapper);
                return filedownlogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return filedownlogPagination.setData(list, list.size());
        }
        return this.list((Wrapper)filedownlogQueryWrapper);
    }

    @Override
    public FileDownLogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FileDownLogEntity::getId, (Object)id);
        return (FileDownLogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(FileDownLogCrForm filedownlogCrForm) {
        String mainId = RandomUtil.uuId();
        FileDownLogEntity entity = JsonUtil.getJsonToBean(filedownlogCrForm, FileDownLogEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, FileDownLogUpForm filedownlogUpForm) {
        UserInfo userInfo = this.userProvider.get();
        FileDownLogEntity entity = this.getInfo(id);
        if (entity != null) {
            FileDownLogEntity subentity = JsonUtil.getJsonToBean(filedownlogUpForm, FileDownLogEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    @DSTransactional
    public void delete(FileDownLogEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

