/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.text.StrFormatter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String NULLSTR = "";
    public static final char SEPARATOR = '_';
    public static final String START = "*";

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StringUtils.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !StringUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Object[] objects) {
        return StringUtils.isNull(objects) || objects.length == 0;
    }

    public static boolean isEmpty(String ... strings) {
        return StringUtils.isNull(strings) || strings.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !StringUtils.isEmpty(objects);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return StringUtils.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StringUtils.isEmpty(map);
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isNull(str) || NULLSTR.equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !StringUtils.isNull(object);
    }

    public static boolean isArray(Object object) {
        return StringUtils.isNotNull(object) && object.getClass().isArray();
    }

    public static String trim(String str) {
        return str == null ? NULLSTR : str.trim();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return NULLSTR;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return NULLSTR;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return NULLSTR;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return NULLSTR;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String substr(String str, int len, String cs) throws UnsupportedEncodingException {
        byte[] br = new byte[len];
        byte[] bt = str.getBytes(cs);
        if (bt.length > len) {
            System.arraycopy(bt, 0, br, 0, len);
            String res = new String(br, cs);
            int resLen = res.length();
            if (str.substring(0, resLen).getBytes(cs).length > len) {
                res = str.substring(0, resLen - 1);
            }
            return res;
        }
        return str;
    }

    public static String format(String template, Object ... params) {
        if (StringUtils.isEmpty(params) || StringUtils.isEmpty(template)) {
            return template;
        }
        return StrFormatter.format(template, params);
    }

    public static String toUnderScoreCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean preCharIsUpperCase = true;
        boolean curreCharIsUpperCase = true;
        boolean nexteCharIsUpperCase = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            preCharIsUpperCase = i > 0 ? Character.isUpperCase(str.charAt(i - 1)) : false;
            curreCharIsUpperCase = Character.isUpperCase(c);
            if (i < str.length() - 1) {
                nexteCharIsUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (preCharIsUpperCase && curreCharIsUpperCase && !nexteCharIsUpperCase) {
                sb.append('_');
            } else if (i != 0 && !preCharIsUpperCase && curreCharIsUpperCase) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return NULLSTR;
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean matches(String str, List<String> strs) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(strs)) {
            return false;
        }
        for (String testStr : strs) {
            if (!StringUtils.matches(str, testStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String str, String ... strs) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(strs)) {
            return false;
        }
        for (String testStr : strs) {
            if (!StringUtils.matches(str, testStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String str, String pattern) {
        if (StringUtils.isEmpty(pattern) || StringUtils.isEmpty(str)) {
            return false;
        }
        pattern = pattern.replaceAll("\\s*", NULLSTR);
        int beginOffset = 0;
        int formerStarOffset = -1;
        int latterStarOffset = -1;
        String remainingUri = str;
        String prefixPattern = NULLSTR;
        String suffixPattern = NULLSTR;
        boolean result = false;
        do {
            prefixPattern = StringUtils.substring(pattern, beginOffset, (formerStarOffset = StringUtils.indexOf((CharSequence)pattern, (CharSequence)START, (int)beginOffset)) > -1 ? formerStarOffset : pattern.length());
            result = remainingUri.contains(prefixPattern);
            if (formerStarOffset == -1) {
                return result;
            }
            if (!result) {
                return false;
            }
            if (!StringUtils.isEmpty(prefixPattern)) {
                remainingUri = StringUtils.substringAfter((String)str, (String)prefixPattern);
            }
            if (!(result = remainingUri.contains(suffixPattern = StringUtils.substring(pattern, formerStarOffset + 1, (latterStarOffset = StringUtils.indexOf((CharSequence)pattern, (CharSequence)START, (int)(formerStarOffset + 1))) > -1 ? latterStarOffset : pattern.length())))) {
                return false;
            }
            if (!StringUtils.isEmpty(suffixPattern)) {
                remainingUri = StringUtils.substringAfter((String)str, (String)suffixPattern);
            }
            beginOffset = latterStarOffset + 1;
        } while (!StringUtils.isEmpty(suffixPattern) && !StringUtils.isEmpty(remainingUri));
        return true;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static List<String> removeRepeatFactor(List<String> list1, List<String> list2) {
        List intersection = list1.stream().filter(item -> list2.contains(item)).collect(Collectors.toList());
        ArrayList<String> listAllDistinct = new ArrayList<String>();
        list1.removeAll(intersection);
        list2.removeAll(intersection);
        listAllDistinct.addAll(list1);
        listAllDistinct.addAll(list2);
        return listAllDistinct;
    }

    public static String stringFilter(String str) {
        String regEx = "[\\u00A0\\s\"`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll(NULLSTR).trim();
    }

    public static int getLength(String s) {
        int length = 0;
        for (int i = 0; i < s.length(); ++i) {
            int ascii = Character.codePointAt(s, i);
            if (ascii >= 0 && ascii <= 255) {
                ++length;
                continue;
            }
            length += 2;
        }
        return length;
    }
}

