package com.bringspring.common.auth.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;


/**
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Data
public class JsbosOauthConfig {

    public static final String PREFIX = "oauth";

    /**
     * 服务器域名
     *
     * @see com.bringspring.common.config.ConfigValueUtil#getApiDomain()
     */
    @Deprecated
    @Value("${config.ApiDomain:}")
    private String jsbosDomain;


    /**
     * 开启单点登录, 需额外代码支持
     */
    private Boolean ssoEnabled = false;

    /**
     * 后端登录完整路径路径
     */
    private String loginPath;

    /**
     * 默认发起的登录协议
     */
    private String defaultSSO = "cas";

    /**
     * 轮询Ticket有效期, 秒
     */
    private long ticketTimeout = 60;

    /**
     * pc端服务器域名
     *
     * @see com.bringspring.common.config.ConfigValueUtil#getFrontDomain()
     */
    @Deprecated
    @Value("${config.FrontDomain:}")
    private String jsbosFrontDomain;

    /**
     * app端服务器域名
     *
     * @see com.bringspring.common.config.ConfigValueUtil#getAppDomain()
     */
    @Deprecated
    @Value("${config.AppDomain:}")
    private String jsbosAppDomain;

}
