package com.bringspring.common.database.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.context.SpringContext;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

/**
 * MybatisPlus配置类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Component
public class MybatisPlusMetaObjectHandler implements MetaObjectHandler {


    private UserProvider userProvider;

    @Override
    public void insertFill(MetaObject metaObject) {
        userProvider = SpringContext.getBean(UserProvider.class);
        UserInfo userInfo = userProvider.get();
        Object enabledMark = this.getFieldValByName("enabledMark", metaObject);
        Object creatorUserId = this.getFieldValByName("creatorUserId", metaObject);
        Object creatorTime = this.getFieldValByName("creatorTime", metaObject);
        Object lastModifyTime = this.getFieldValByName("lastModifyTime", metaObject);

        Object lastModifyUserId = this.getFieldValByName("lastModifyUserId", metaObject);
        if (ObjectUtils.isEmpty(enabledMark)) {
            this.setFieldValByName("enabledMark", 1, metaObject);
        }
        if (null != userInfo && ObjectUtils.isEmpty(creatorUserId)) {
            this.setFieldValByName("creatorUserId", userInfo.getUserId(), metaObject);
        }
        if (ObjectUtils.isEmpty(creatorTime)) {
            this.setFieldValByName("creatorTime", DateUtil.getNowDate(), metaObject);
        }
        if (ObjectUtils.isEmpty(lastModifyTime)) {
            this.setFieldValByName("lastModifyTime", DateUtil.getNowDate(), metaObject);
        }
        if (null != userInfo && ObjectUtils.isEmpty(lastModifyUserId)) {
            this.setFieldValByName("lastModifyUserId", userInfo.getUserId(), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        userProvider = SpringContext.getBean(UserProvider.class);
        UserInfo userInfo = userProvider.get();

        this.setFieldValByName("lastModifyTime", DateUtil.getNowDate(), metaObject);
        if (null != userInfo ) {
            this.setFieldValByName("lastModifyUserId", userInfo.getUserId(), metaObject);
        }

    }

}
