package com.bringspring.common.database.enums;

import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.source.impl.DbPostgre;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 别名枚举
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/6/29
 */
@AllArgsConstructor
@Getter
public enum DbAliasEnum {


    /* =========================== 表 ============================ */
    /**
     * 表大小
     */
    TABLE_SIZE("TABLE_SIZE"),

    /**
     * 表名
     */
    TABLE_NAME("TABLE_NAME"),

    /**
     * 表注释
     */
    TABLE_COMMENT("TABLE_COMMENT"),

    /**
     * 类型
     */
    TABLE_TYPE("TABLE_TYPE"),

    /**
     * 表总数
     */
    TABLE_SUM("TABLE_SUM"),

    /* =========================== 字段 ============================ */
    /**
     * 字段名
     */
    FIELD("FIELD"),

    /**
     * 字段注释
     */
    FIELD_COMMENT("FIELD_COMMENT"),

    /**
     * 字段默认值
     */
    DEFAULT_VALUE("DEFAULT_VALUE"),

    /**
     * 自增
     */
    AUTO_INCREMENT("AUTO_INCREMENT"),

    /**
     * 默认值（用于判断自增长）
     */
    COLUMN_DEFAULT("COLUMN_DEFAULT"),

    /**
     * 自增
     */
    IS_IDENTITY("IS_IDENTITY"),

    /**
     * 允空
     * 允许：1，不允许：0
     */
    ALLOW_NULL("ALLOW_NULL") {
        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    },
    
    /**
     * 主键
     * 存在：1，不存在：0
     */
    PRIMARY_KEY("PRIMARY_KEY") {
        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    },

    /* ------------- 字段数据类型 ------------- */

    /**
     * 类型
     */
    DATA_TYPE("DATA_TYPE"),

    /**
     * 以字符为单位的最大长度，适于二进制数据、字符数据，或者文本和图像数据。否则，返回 NULL
     * 例如：text、varchar（int时为null），其中varchar为可变长度，text为固定长度
     */
    CHAR_LENGTH("CHAR_LENGTH"),

    /**
     * precision:数值精度（整个数值的长度）
     * 例如：decimal
     * 注意：int(i)类型时，无论i是多少，NUMERIC_PRECISION都是10，在填充0的时候i才会起作用
     */
    NUM_PRECISION("NUM_PRECISION"),

    /**
     * scale:数值标度（小数部分的长度）
     */
    NUM_SCALE("NUM_SCALE"),


    /* =========================== 其他 ============================ */

    /**
     * 总数返回
     */
    TOTAL_RECORD("totalRecord"),

    /**
     * 总数
     */
    TOTAL("total"),

    /**
     * 自增主键触发器判断
     */
    AUTO_TRIGGER("AUTO_TRIGGER")
    ;


    public Integer isTrue() {
        return null;
    }

    public Integer isFalse() {
        return null;
    }

    private final String alias;

    public String AS() {
        return alias;
    }

    public String asByDb(DbBase db) {
        if (DbPostgre.class.equals(db.getClass())) {
            //postgre别名只能输出小写，Oracle只能大写
            //Mysql默认，SqlServer默认
            return alias.toLowerCase();
        } else if (DbOracle.class.equals(db.getClass())) {
            return alias.toUpperCase();
        } else {
            return alias;
        }
    }

    public static String getAsByDb(DbBase db, String keyWord) {
        if (DbPostgre.class.equals(db.getClass())) {
            //postgre别名只能输出小写，Oracle只能大写
            //Mysql默认，SqlServer默认
            return keyWord.toLowerCase();
        } else if (DbOracle.class.equals(db.getClass())) {
            return keyWord.toUpperCase();
        } else {
            return keyWord;
        }
    }

    public String getAlias(String dbEncode) {
        return getAlias(dbEncode, alias);
    }

    public static String getAlias(String dbEncode, String keyWord){
        if (DbBase.POSTGRE_SQL.equals(dbEncode)) {
            //postgre别名只能输出小写，Oracle只能大写
            //Mysql默认，SqlServer默认
            return keyWord.toLowerCase();
        } else if (DbBase.ORACLE.equals(dbEncode)) {
            return keyWord.toUpperCase();
        } else {
            return keyWord;
        }
    }
}
