package com.bringspring.common.license.client;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.license.client.model.LicenseVerifyParam;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.Md5Util;
import de.schlichtherle.license.LicenseContentException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 * 在项目启动时安装证书
 * @desc
 *
 * @author 朱俊杰
 * 
 * @date 2019/3/14 13:18
 */
@Component
@Slf4j
public class LicenseCheckListener implements ApplicationListener<ContextRefreshedEvent> {

    /**
     * 证书subject
     */
    @Value("${config.subject:jsbos}")
    private String subject;

    /**
     * 公钥别称
     */
    @Value("${config.publicAlias:jsbos}")
    private String publicAlias;

    /**
     * 访问公钥库的密码
     */
    @Value("${config.storePass:RongKe@888}")
    private String storePass;

    /**
     * 证书生成路径
     */
    @Value("${config.licensePath}")
    private String licensePath;

    /**
     * 密钥库存储路径
     */
    @Value("${config.publicKeysStorePath:jsbos_public.keystore}")
    private String publicKeysStorePath;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext().getParent();
        if(context == null){
            try {
                this.install();
            } catch (LicenseContentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean install() throws LicenseContentException {
        if(StringUtils.isNotBlank(licensePath)){
            log.debug("============= 开始安装证书 =============+");
            CustomLicenseManager customLicenseManager=new CustomLicenseManager();
            LicenseCheckModel model = customLicenseManager.getServerInfos();
            if (com.bringspring.common.util.StringUtils.isEmpty(model.getCpuSerial(), model.getMainBoardSerial())) {
                log.error("============= Cpu或主板序列号为空 =============");
                log.error("处理器：{}",model.getCpuSerial());
                log.error("主板序列号：{}",model.getMainBoardSerial());
                throw new LicenseContentException("Cpu或主板序列号不能为空");
            }
            String pcCode= Md5Util.getStringMd5(JSONObject.toJSONString(model));
            log.debug("============= 器码：%s =============",pcCode);
            LicenseVerifyParam param = new LicenseVerifyParam();
            param.setSubject(subject);
            param.setPublicAlias(publicAlias);
            param.setStorePass(storePass);
            param.setLicensePath(licensePath);
            param.setPublicKeysStorePath(publicKeysStorePath);
            LicenseVerify licenseVerify = new LicenseVerify();
            //安装证书
            try {
                licenseVerify.install(param);
                log.debug("============= 证书安装成功 =============");
            } catch (Exception e) {
                log.error("============= 证书安装失败 =============",e.getMessage());
                return false;
            }
        }
        return true;
    }


    public static void main(String[] args) {
        LicenseVerifyParam param = new LicenseVerifyParam();
        param.setSubject("jsbos");
        param.setPublicAlias("jsbos");
        param.setStorePass("RongKe@888");

        param.setLicensePath("D:/License/license.lic");
        param.setPublicKeysStorePath("jsbos_public.keystore");
        LicenseVerify licenseVerify = new LicenseVerify();
        //安装证书
        try {
            licenseVerify.install(param);
            log.debug("++++++++ 证书安装成功 ++++++++");
        } catch (Exception e) {
            log.error("++++++++ 证书安装失败 ++++++++");
        }
    }
}
