/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.config;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;

@org.springframework.context.annotation.Configuration
@ComponentScan(value={"com.bringspring"})
public class DbTableConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbTableConfig.class);
    @Value(value="${config.initTable:false}")
    private boolean initTable;
    @Value(value="${config.SoftVersion}")
    private String softVersion;
    @Value(value="${config.sqlFile}")
    private String sqlFile;
    @Autowired
    private DataSourceUtil dataSourceModel;
    static final String ALIASES_PACKAGE = "com.bringspring.**.entity";

    @PostConstruct
    public void initDbTable() throws Exception {
        if (this.initTable) {
            DbConnDTO connDTO = this.setResource(this.dataSourceModel);
            List<DbTableModel> tableModelList = this.getListCommon(null, DbTableModel.class, connDTO);
            if (tableModelList.size() < 1) {
                this.initDbInfo(this.setResource(this.dataSourceModel));
            } else {
                String nowVersion = this.getVersion(this.setResource(this.dataSourceModel));
                int result = 0;
                try {
                    result = this.compareVersions(this.softVersion.substring(0, this.softVersion.indexOf("-")), nowVersion.substring(1));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                if (result > 0) {
                    List<Class<?>> classes = DbTableConfig.scanClasses();
                    for (Class<?> clazz : classes) {
                        ArrayList<Map<String, String>> fieldList;
                        TableName tableNameAnnotation = clazz.getAnnotation(TableName.class);
                        String tableName = tableNameAnnotation.value().toUpperCase();
                        ArrayList<String> tableList = new ArrayList<String>();
                        for (DbTableModel tableModel : tableModelList) {
                            tableList.add(tableModel.getTable().toUpperCase());
                        }
                        Field[] fields = clazz.getDeclaredFields();
                        Field[] superFields = clazz.getSuperclass().getDeclaredFields();
                        Field[] resultFields = new Field[fields.length + superFields.length];
                        System.arraycopy(fields, 0, resultFields, 0, fields.length);
                        System.arraycopy(superFields, 0, resultFields, fields.length, superFields.length);
                        boolean tableContains = tableList.contains(tableName);
                        if (tableContains) {
                            List<DbTableFieldModel> listCommon = this.getListCommon(tableName, DbTableFieldModel.class, connDTO);
                            fieldList = new ArrayList();
                            ArrayList<Map<String, String>> idList = new ArrayList<Map<String, String>>();
                            ArrayList<Map<String, String>> newFieldList = new ArrayList<Map<String, String>>();
                            for (DbTableFieldModel fieldModel : listCommon) {
                                fieldList.add((Map<String, String>)((Object)fieldModel.getField().toUpperCase()));
                            }
                            Field[] fieldArray = resultFields;
                            int n = fieldArray.length;
                            for (int i = 0; i < n; ++i) {
                                TableField tableFieldAnnotation;
                                boolean contains;
                                TableId tableIdAnnotation;
                                Field field = fieldArray[i];
                                String fieldStr = "";
                                String id = "";
                                HashMap<String, String> fieldMap = new HashMap<String, String>();
                                HashMap<String, String> idMap = new HashMap<String, String>();
                                if (field.isAnnotationPresent(TableId.class) && StringUtils.isNotEmpty(id = (tableIdAnnotation = field.getAnnotation(TableId.class)).value().toUpperCase()) && !(contains = fieldList.contains(id))) {
                                    idMap.put("id", id);
                                    idMap.put("fieldType", field.getType().toString());
                                    idList.add(idMap);
                                }
                                if (!field.isAnnotationPresent(TableField.class) || !StringUtils.isNotEmpty(fieldStr = (tableFieldAnnotation = field.getAnnotation(TableField.class)).value().toUpperCase()) || (contains = fieldList.contains(fieldStr))) continue;
                                fieldMap.put("fieldStr", fieldStr);
                                fieldMap.put("fieldType", field.getType().toString());
                                newFieldList.add(fieldMap);
                            }
                            if (idList.size() <= 0 && newFieldList.size() <= 0) continue;
                            this.updateCreatField(tableName, idList, newFieldList, this.setResource(this.dataSourceModel));
                            continue;
                        }
                        HashMap<String, String> tableMap = new HashMap<String, String>();
                        fieldList = new ArrayList<Map<String, String>>();
                        ArrayList<Map<String, String>> newTableList = new ArrayList<Map<String, String>>();
                        for (Field field : resultFields) {
                            TableField tableFieldAnnotation;
                            TableId tableIdAnnotation;
                            HashMap<String, String> fieldMap = new HashMap<String, String>();
                            HashMap<String, String> newTableMap = new HashMap<String, String>();
                            String fieldStr = "";
                            String id = "";
                            if (field.isAnnotationPresent(TableId.class) && StringUtils.isNotEmpty(id = (tableIdAnnotation = field.getAnnotation(TableId.class)).value().toUpperCase())) {
                                newTableMap.put("id", id);
                                newTableMap.put("fieldType", field.getType().toString());
                                newTableList.add(newTableMap);
                            }
                            if (!field.isAnnotationPresent(TableField.class) || !StringUtils.isNotEmpty(fieldStr = (tableFieldAnnotation = field.getAnnotation(TableField.class)).value().toUpperCase())) continue;
                            fieldMap.put("fieldStr", fieldStr);
                            fieldMap.put("fieldType", field.getType().toString());
                            fieldList.add(fieldMap);
                        }
                        tableMap.put("tableName", tableName);
                        this.addCreatField(tableMap, newTableList, fieldList, this.setResource(this.dataSourceModel));
                    }
                }
            }
        }
    }

    private String CreatTableSqlString(String dataSourceType, List<Map<String, String>> newTableList, Map<String, String> tableMap, List<Map<String, String>> fieldList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSourceType.contains("MySQL")) {
            int i;
            stringBuffer.append("CREATE table  `").append(tableMap.get("tableName").toString()).append("` ( `");
            Object primary = "";
            for (i = 0; i < newTableList.size(); ++i) {
                Map<String, String> newTabledMap = newTableList.get(i);
                if (!StringUtils.isNotEmpty(newTabledMap.get("id"))) continue;
                if (newTabledMap.get("fieldType").toUpperCase().contains("STRING")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` ").append(" VARCHAR(255) NOT NULL , ");
                } else if (newTabledMap.get("fieldType").toUpperCase().contains("INT") || newTabledMap.get("fieldType").toUpperCase().contains("LONG") || newTabledMap.get("fieldType").toUpperCase().contains("BIGDECIMAL")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` INT NOT NULL , ");
                } else if (newTabledMap.get("fieldType").toUpperCase().contains("DATE")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` DATETIME NOT NULL , ");
                } else {
                    stringBuffer.append(newTabledMap.get("id")).append("` ").append(" TEXT NOT NULL , ");
                }
                if (i < newTableList.size() - 1) {
                    stringBuffer.append("`");
                }
                if (i == 0) {
                    primary = "PRIMARY KEY (";
                }
                primary = i == newTableList.size() - 1 ? (String)primary + "`" + newTabledMap.get("id") + "`)" : (String)primary + "`" + newTabledMap.get("id") + "` ,";
            }
            for (i = 0; i < fieldList.size(); ++i) {
                Map<String, String> fieldMap = fieldList.get(i);
                if (i == 0) {
                    stringBuffer.append("`");
                }
                if (fieldMap.get("fieldType").toUpperCase().contains("STRING")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` ").append(" VARCHAR(255) NULL , ");
                } else if (fieldMap.get("fieldType").toUpperCase().contains("INT") || fieldMap.get("fieldType").toUpperCase().contains("LONG") || fieldMap.get("fieldType").toUpperCase().contains("BIGDECIMAL")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` INT NULL , ");
                } else if (fieldMap.get("fieldType").toUpperCase().contains("DATE")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` DATETIME NULL , ");
                } else {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` ").append(" TEXT NULL , ");
                }
                if (i >= fieldList.size() - 1) continue;
                stringBuffer.append("`");
            }
            stringBuffer.append((String)primary).append(")");
        } else if (dataSourceType.contains("Oracle") || dataSourceType.contains("PostgreSQL") || dataSourceType.contains("SQLServer")) {
            // empty if block
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDbInfo(DbConnDTO connDTO) {
        Reader reader = null;
        try {
            Connection connection = connDTO.getConn();
            ScriptRunner scriptRunner = new ScriptRunner(connection);
            scriptRunner.setAutoCommit(false);
            scriptRunner.setStopOnError(true);
            File file = new File(this.sqlFile);
            reader = new FileReader(file);
            scriptRunner.runScript(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<Class<?>> scanClasses() {
        ArrayList classList = new ArrayList();
        new ConfigurationBuilder().setScanners(new Scanner[]{new TypeAnnotationsScanner()}).setUrls(ClasspathHelper.forPackage((String)ALIASES_PACKAGE, (ClassLoader[])new ClassLoader[0]));
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[0]);
        ConfigurationBuilder config1 = new ConfigurationBuilder();
        for (URL url : config.getUrls()) {
            if (!url.toString().contains("bringspring") && !url.toString().contains("classes")) continue;
            config1.getUrls().add(url);
        }
        Reflections reflections = new Reflections((Configuration)config1);
        Set allClasses = reflections.getTypesAnnotatedWith(TableName.class);
        classList.addAll(allClasses);
        return classList;
    }

    private DbConnDTO setResource(DataSourceUtil dataSourceModel) throws DataException {
        try {
            return new DbConnDTO(DbTypeUtil.getDb(dataSourceModel), dataSourceModel, ConnUtil.getConn(dataSourceModel));
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException {
        try {
            Connection conn = connDTO.getConn();
            SqlBase sqlBase = connDTO.getDbBase().getSqlBase();
            PreparedStatementDTO preparedStatementDTO = null;
            preparedStatementDTO = modType == DbTableModel.class ? sqlBase.getTableListPSD(conn, connDTO.getDbSource()) : sqlBase.getFieldListPSD(conn, table, connDTO.getDbSource());
            return JdbcUtil.queryCustomMods(preparedStatementDTO, modType);
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private void updateCreatField(String tableName, List<Map<String, String>> idList, List<Map<String, String>> newFieldList, DbConnDTO connDTO) throws Exception {
        Connection conn = connDTO.getConn();
        if (conn == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = this.addFieldSqlString(connDTO.getDbSource().getDbType(), tableName, idList, newFieldList);
        log.info("\u65b0\u589e\u5b57\u6bb5\u8981\u6267\u884c\u7684sql---" + sql);
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }

    private void addCreatField(Map<String, String> tableMap, List<Map<String, String>> newTableList, List<Map<String, String>> fieldList, DbConnDTO connDTO) throws Exception {
        Connection conn = connDTO.getConn();
        if (conn == null) {
            throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
        }
        Statement stmt = conn.createStatement();
        String sql = this.CreatTableSqlString(connDTO.getDbSource().getDbType(), newTableList, tableMap, fieldList);
        log.info("\u521b\u5efa\u8868\u8981\u6267\u884c\u7684sql---" + sql);
        stmt.executeUpdate(sql);
        stmt.close();
        conn.close();
    }

    private String addFieldSqlString(String dataSourceType, String tableName, List<Map<String, String>> idList, List<Map<String, String>> newFieldList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSourceType.contains("MySQL") || dataSourceType.contains("Oracle")) {
            int i;
            stringBuffer.append("ALTER TABLE  `").append(tableName);
            Object primary = "";
            for (i = 0; i < idList.size(); ++i) {
                Map<String, String> newTabledMap = idList.get(i);
                if (i == 0) {
                    stringBuffer.append("` ADD `");
                } else {
                    stringBuffer.append(" ADD `");
                }
                if (!StringUtils.isNotEmpty(newTabledMap.get("id"))) continue;
                if (newTabledMap.get("fieldType").toUpperCase().contains("STRING")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` ").append(" VARCHAR(255) NOT NULL ,");
                } else if (newTabledMap.get("fieldType").toUpperCase().contains("INT") || newTabledMap.get("fieldType").toUpperCase().contains("LONG") || newTabledMap.get("fieldType").toUpperCase().contains("BIGDECIMAL")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` INT NOT NULL ,");
                } else if (newTabledMap.get("fieldType").toUpperCase().contains("DATE")) {
                    stringBuffer.append(newTabledMap.get("id")).append("` DATETIME NOT NULL ,");
                } else {
                    stringBuffer.append(newTabledMap.get("id")).append("` ").append(" TEXT NOT NULL ,");
                }
                if (i == 0) {
                    primary = "DROP PRIMARY KEY, ADD PRIMARY KEY (";
                }
                primary = i == idList.size() - 1 ? (String)primary + "`" + newTabledMap.get("id") + "`)" : (String)primary + "`" + newTabledMap.get("id") + "` ,";
            }
            for (i = 0; i < newFieldList.size(); ++i) {
                Map<String, String> fieldMap = newFieldList.get(i);
                if (i == 0) {
                    if (idList.size() < 1) {
                        stringBuffer.append("` ADD `");
                    } else {
                        stringBuffer.append(" ADD `");
                    }
                } else {
                    stringBuffer.append(" ADD `");
                }
                if (fieldMap.get("fieldType").toUpperCase().contains("STRING")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` ").append(" VARCHAR(255) NULL ");
                } else if (fieldMap.get("fieldType").toUpperCase().contains("INT") || fieldMap.get("fieldType").toUpperCase().contains("LONG") || fieldMap.get("fieldType").toUpperCase().contains("BIGDECIMAL")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` INT NULL ");
                } else if (fieldMap.get("fieldType").toUpperCase().contains("DATE")) {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` DATETIME NULL ");
                } else {
                    stringBuffer.append(fieldMap.get("fieldStr")).append("` ").append(" TEXT NULL ");
                }
                if (idList.size() > 0) {
                    stringBuffer.append(" ,");
                    continue;
                }
                if (i >= newFieldList.size() - 1) continue;
                stringBuffer.append(" ,");
            }
            stringBuffer.append((String)primary);
        } else if (dataSourceType.contains("PostgreSQL") || dataSourceType.contains("SQLServer")) {
            // empty if block
        }
        return stringBuffer.toString();
    }

    private String getVersion(DbConnDTO connDTO) throws Exception {
        String nowVersion;
        block7: {
            nowVersion = "";
            Connection conn = null;
            Statement stmt = null;
            try {
                LinkedHashMap resultMap = new LinkedHashMap();
                conn = connDTO.getConn();
                if (conn != null) {
                    stmt = conn.createStatement();
                    String sql = "select key_value from base_system_config where key_name = 'sysVersion'";
                    ResultSet rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        nowVersion = rs.getString("key_value");
                    }
                    stmt.close();
                    conn.close();
                    break block7;
                }
                throw new Exception("\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u94fe\u63a5\u914d\u7f6e");
            }
            catch (Exception e) {
                throw new Exception("\u7cfb\u7edf\u5f02\u5e38");
            }
            finally {
                stmt.close();
                conn.close();
            }
        }
        return nowVersion;
    }

    private int compareVersions(String version1, String version2) {
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int length = Math.max(v1.length, v2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < v1.length ? Integer.parseInt(v1[i]) : 0;
            int n = num2 = i < v2.length ? Integer.parseInt(v2[i]) : 0;
            if (num1 < num2) {
                return -1;
            }
            if (num1 <= num2) continue;
            return 1;
        }
        return 0;
    }
}

