/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.enums.base;

import com.bringspring.common.database.model.dto.PrepSqlDTO;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.sql.enums.SqlDMEnum;
import com.bringspring.common.database.sql.enums.SqlKingbaseESEnum;
import com.bringspring.common.database.sql.enums.SqlMySQLEnum;
import com.bringspring.common.database.sql.enums.SqlOracleEnum;
import com.bringspring.common.database.sql.enums.SqlPostgreSQLEnum;
import com.bringspring.common.database.sql.enums.SqlSQLServerEnum;
import com.bringspring.common.database.sql.enums.base.SqlFrameBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public enum SqlComEnum implements SqlFrameBase
{
    TABLES(SqlMySQLEnum.TABLES, SqlOracleEnum.TABLES, SqlSQLServerEnum.TABLES, SqlDMEnum.TABLES, SqlKingbaseESEnum.TABLES, SqlPostgreSQLEnum.TABLES),
    TABLESANDVIEW(SqlMySQLEnum.TABLESANDVIEW, SqlOracleEnum.TABLESANDVIEW, SqlSQLServerEnum.TABLESANDVIEW, SqlDMEnum.TABLESANDVIEW, SqlKingbaseESEnum.TABLESANDVIEW, SqlPostgreSQLEnum.TABLESANDVIEW),
    TABLE(SqlMySQLEnum.TABLE, SqlOracleEnum.TABLE, SqlSQLServerEnum.TABLE, SqlDMEnum.TABLE, SqlKingbaseESEnum.TABLE, SqlPostgreSQLEnum.TABLE),
    FIELDS(SqlMySQLEnum.FIELDS, SqlOracleEnum.FIELDS, SqlSQLServerEnum.FIELDS, SqlDMEnum.FIELDS, SqlKingbaseESEnum.FIELDS, SqlPostgreSQLEnum.FIELDS),
    EXISTS_TABLE(SqlMySQLEnum.EXISTS_TABLE, SqlOracleEnum.EXISTS_TABLE, SqlSQLServerEnum.EXISTS_TABLE, SqlDMEnum.EXISTS_TABLE, SqlKingbaseESEnum.EXISTS_TABLE, SqlPostgreSQLEnum.EXISTS_TABLE),
    CREATE_TABLE((SqlFrameBase)SqlOracleEnum.CREATE_TABLE, Arrays.asList("{table}", "{column}", "{dataType}", "[<DEFAULT> {defaultValue}]", "[[NOT] [NULL]]", "[AUTO_INCREMENT]", "[<COMMENT> {comment}]", "{primarykeys}"), SqlMySQLEnum.CREATE_TABLE, SqlSQLServerEnum.CREATE_TABLE, SqlDMEnum.CREATE_TABLE, SqlKingbaseESEnum.CREATE_TABLE, SqlPostgreSQLEnum.CREATE_TABLE),
    ADD_COLUMN((SqlFrameBase)SqlMySQLEnum.ALTER_ADD_MODIFY, Arrays.asList("<ADD|MODIFY>", "{table}", "{column}", "{dataType}", "[[NOT] [NULL]]", "[<DEFAULT> {defaultValue}]", "{comment}"), SqlOracleEnum.ADD_COLUMN, SqlPostgreSQLEnum.ADD_COLUMN, SqlDMEnum.ALTER_ADD, SqlKingbaseESEnum.ALTER_ADD, SqlSQLServerEnum.ALTER_COLUMN),
    DROP_TABLE((SqlFrameBase)SqlOracleEnum.DROP_TABLE, Arrays.asList("{table}"), SqlMySQLEnum.DROP_TABLE),
    RE_TABLE_NAME((SqlFrameBase)SqlMySQLEnum.RE_TABLE_NAME, Arrays.asList("{oldTable}", "{newTable}"), SqlKingbaseESEnum.RE_TABLE_NAME, SqlPostgreSQLEnum.RE_TABLE_NAME, SqlSQLServerEnum.RE_TABLE_NAME),
    COMMENT_TABLE((SqlFrameBase)SqlOracleEnum.COMMENT_TABLE, Arrays.asList("{table}", "'{comment}'"), SqlMySQLEnum.COMMENT_TABLE, SqlSQLServerEnum.COMMENT_TABLE),
    COMMENT_COLUMN((SqlFrameBase)SqlOracleEnum.COMMENT_COLUMN, Arrays.asList("{table}", "{column}", "'{comment}'", "{dataType}", "[DEFAULT {defaultValue}]"), SqlMySQLEnum.COMMENT_COLUMN, SqlSQLServerEnum.COMMENT_COLUMN),
    SELECT_TABLE((SqlFrameBase)SqlMySQLEnum.SELECT_TABLE, Arrays.asList("{table}")),
    COUNT_SIZE((SqlFrameBase)SqlMySQLEnum.COUNT_SIZE, Arrays.asList("{totalAlias}", "{selectSql}")),
    COUNT_SIZE_TABLE((SqlFrameBase)SqlMySQLEnum.COUNT_TABLE_SIZE, Arrays.asList("{totalAlias}", "{table}")),
    INSERT((SqlFrameBase)SqlMySQLEnum.INSERT, Arrays.asList("{table}", "[\u3010{column},\u3011]", "\u3010{value},\u3011")),
    DELETE_ALL((SqlFrameBase)SqlMySQLEnum.DELETE_ALL, Collections.singletonList("{table}")),
    ORDER_PAGE((SqlFrameBase)SqlMySQLEnum.ORDER_PAGE, Arrays.asList("{selectSql}", "{orderColumn}", "{beginIndex}", "{endIndex}", "{pageSize}", "[DESC]"), SqlOracleEnum.ORDER_PAGE, SqlSQLServerEnum.ORDER_PAGE, SqlPostgreSQLEnum.ORDER_PAGE),
    ORDER((SqlFrameBase)SqlMySQLEnum.ORDER, Arrays.asList("{column}", "[DESC]")),
    LIKE((SqlFrameBase)SqlMySQLEnum.LIKE, Arrays.asList("{selectSql}", "{column}", "{condition}"));

    private String sqlFrame;
    private SqlFrameBase baseSqlEnum;
    private List<SqlFrameBase> frameEnums;
    private List<String> frameParamList;
    private final String dbEncode = "common";

    private SqlComEnum(SqlFrameBase baseSqlEnum, List<String> frameParamList) {
        this.baseSqlEnum = baseSqlEnum;
        this.sqlFrame = baseSqlEnum.getSqlFrame();
        this.frameParamList = frameParamList;
        this.frameEnums = new ArrayList<SqlFrameBase>();
        this.frameEnums.add(baseSqlEnum);
    }

    private SqlComEnum(SqlFrameBase baseSqlEnum, List<String> frameParamList, SqlFrameBase ... frameEnums) {
        this.baseSqlEnum = baseSqlEnum;
        this.sqlFrame = baseSqlEnum.getSqlFrame();
        this.frameParamList = frameParamList;
        ArrayList<SqlFrameBase> frameEnumsList = new ArrayList<SqlFrameBase>(Arrays.asList(frameEnums));
        frameEnumsList.add(baseSqlEnum);
        this.frameEnums = frameEnumsList;
    }

    private SqlComEnum(SqlFrameBase ... frameEnums) {
        this.frameEnums = Arrays.asList(frameEnums);
    }

    public SqlFrameBase getSqlFrameEnum(String dbEncode) {
        if (this.getFrameEnums() != null) {
            for (SqlFrameBase sqlEnum : this.getFrameEnums()) {
                if (!sqlEnum.getDbEncode().equals(dbEncode)) continue;
                return sqlEnum;
            }
        }
        return null;
    }

    public SqlFrameBase getSqlFrameEnum(SqlFrameBase sqlFrameBase) {
        if (this.getFrameEnums() != null) {
            for (SqlFrameBase sqlEnum : this.getFrameEnums()) {
                if (!sqlEnum.equals(sqlFrameBase)) continue;
                return sqlEnum;
            }
        }
        return null;
    }

    @Override
    public PrepSqlDTO getPrepSqlDto(DbSourceOrDbLink dataSourceMod, String table) {
        SqlFrameBase sysTemSqlEnum = this.getSqlFrameEnum(dataSourceMod.init().getDbType());
        return sysTemSqlEnum.getPrepSqlDto(dataSourceMod, table);
    }

    @Override
    @Generated
    public String getSqlFrame() {
        return this.sqlFrame;
    }

    @Generated
    public SqlFrameBase getBaseSqlEnum() {
        return this.baseSqlEnum;
    }

    @Generated
    public List<SqlFrameBase> getFrameEnums() {
        return this.frameEnums;
    }

    @Generated
    public List<String> getFrameParamList() {
        return this.frameParamList;
    }

    @Override
    @Generated
    public String getDbEncode() {
        return this.dbEncode;
    }

    @Generated
    private SqlComEnum(String sqlFrame, SqlFrameBase baseSqlEnum, List<SqlFrameBase> frameEnums, List<String> frameParamList) {
        this.sqlFrame = sqlFrame;
        this.baseSqlEnum = baseSqlEnum;
        this.frameEnums = frameEnums;
        this.frameParamList = frameParamList;
    }
}

