/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bringspring.common.base.entity.SuperExtendEntity;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.sql.model.DbStruct;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import lombok.Generated;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
public class DataSourceUtil
extends SuperExtendEntity.SuperExtendDescriptionEntity
implements DbSourceOrDbLink {
    @TableField(value="db_type")
    private String dbType;
    @TableField(value="host")
    private String host;
    @TableField(value="port")
    private Integer port;
    @TableField(value="service_name")
    private String serviceName;
    @TableField(value="db_name")
    private String dbName;
    @TableField(value="user_name")
    private String userName;
    @TableField(value="password")
    private String password;
    @TableField(value="table_space")
    private String dbTableSpace;
    @TableField(value="db_schema")
    private String dbSchema;
    @TableField(exist=false)
    private String urlParams;
    @TableField(exist=false)
    private String url;
    @TableField(exist=false)
    private String prepareUrl;
    @TableField(exist=false)
    private String driver;
    @TableField(value="oracle_param")
    private String oracleParam;

    public String getAutoUsername() throws DataException {
        if (StringUtils.isEmpty(this.userName)) {
            return DbTypeUtil.getEncodeDb(this.dbType).getDbaUsername();
        }
        return this.userName;
    }

    public String getAutoPassword() throws DataException {
        if (StringUtils.isEmpty(this.password)) {
            return this.getAutoUsername();
        }
        return this.password;
    }

    @Override
    public DbLinkEntity init() {
        return this.init(null);
    }

    @Override
    public DbLinkEntity init(String dbName) {
        DbLinkEntity dbLinkEntity = new DbLinkEntity();
        BeanUtils.copyProperties((Object)this, (Object)dbLinkEntity);
        if (StringUtils.isNotEmpty(dbName)) {
            dbLinkEntity.setDbName(dbName);
        }
        return dbLinkEntity;
    }

    @Override
    public DbStruct getDbStruct() {
        DbStruct dbStruct = new DbStruct();
        dbStruct.setUserName(this.getUserName());
        dbStruct.setOracleDbSchema(this.getUserName());
        dbStruct.setDmDbSchema(this.getUserName());
        dbStruct.setDbTableSpace(this.getDbTableSpace());
        dbStruct.setMysqlDbName(this.getDbName());
        dbStruct.setSqlServerDbName(this.getDbName());
        dbStruct.setKingBaseDbName(this.getDbName());
        dbStruct.setPostGreDbName(this.getDbName());
        if (StringUtils.isNotEmpty(this.getDbSchema())) {
            dbStruct.setOracleDbSchema(this.getDbSchema());
            dbStruct.setDmDbSchema(this.getDbSchema());
            dbStruct.setSqlServerDbSchema(this.getDbSchema());
            dbStruct.setKingBaseDbSchema(this.getDbSchema());
            dbStruct.setPostGreDbSchema(this.getDbSchema());
        }
        dbStruct.setOracleParam(this.getOracleParam());
        return dbStruct;
    }

    @Override
    public DataSourceDTO convertDTO() {
        return this.convertDTO(null);
    }

    @Override
    public DataSourceDTO convertDTO(String dbName) {
        return this.convertDTO(dbName, 1);
    }

    protected DataSourceDTO convertDTO(String dbName, Integer dataSourceFrom) {
        DataSourceDTO dataSourceDTO = new DataSourceDTO();
        BeanUtils.copyProperties((Object)this, (Object)dataSourceDTO);
        if (StringUtils.isNotEmpty(dbName)) {
            dataSourceDTO.setDbName(dbName);
        }
        dataSourceDTO.setDataSourceFrom(dataSourceFrom);
        return dataSourceDTO;
    }

    @Generated
    public DataSourceUtil() {
    }

    @Generated
    public String getDbType() {
        return this.dbType;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getDbName() {
        return this.dbName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDbTableSpace() {
        return this.dbTableSpace;
    }

    @Generated
    public String getDbSchema() {
        return this.dbSchema;
    }

    @Generated
    public String getUrlParams() {
        return this.urlParams;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getPrepareUrl() {
        return this.prepareUrl;
    }

    @Generated
    public String getDriver() {
        return this.driver;
    }

    @Generated
    public String getOracleParam() {
        return this.oracleParam;
    }

    @Generated
    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDbTableSpace(String dbTableSpace) {
        this.dbTableSpace = dbTableSpace;
    }

    @Generated
    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    @Generated
    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setPrepareUrl(String prepareUrl) {
        this.prepareUrl = prepareUrl;
    }

    @Generated
    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Generated
    public void setOracleParam(String oracleParam) {
        this.oracleParam = oracleParam;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceUtil)) {
            return false;
        }
        DataSourceUtil other = (DataSourceUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbTableSpace = this.getDbTableSpace();
        String other$dbTableSpace = other.getDbTableSpace();
        if (this$dbTableSpace == null ? other$dbTableSpace != null : !this$dbTableSpace.equals(other$dbTableSpace)) {
            return false;
        }
        String this$dbSchema = this.getDbSchema();
        String other$dbSchema = other.getDbSchema();
        if (this$dbSchema == null ? other$dbSchema != null : !this$dbSchema.equals(other$dbSchema)) {
            return false;
        }
        String this$urlParams = this.getUrlParams();
        String other$urlParams = other.getUrlParams();
        if (this$urlParams == null ? other$urlParams != null : !this$urlParams.equals(other$urlParams)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$prepareUrl = this.getPrepareUrl();
        String other$prepareUrl = other.getPrepareUrl();
        if (this$prepareUrl == null ? other$prepareUrl != null : !this$prepareUrl.equals(other$prepareUrl)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$oracleParam = this.getOracleParam();
        String other$oracleParam = other.getOracleParam();
        return !(this$oracleParam == null ? other$oracleParam != null : !this$oracleParam.equals(other$oracleParam));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceUtil;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbTableSpace = this.getDbTableSpace();
        result = result * 59 + ($dbTableSpace == null ? 43 : $dbTableSpace.hashCode());
        String $dbSchema = this.getDbSchema();
        result = result * 59 + ($dbSchema == null ? 43 : $dbSchema.hashCode());
        String $urlParams = this.getUrlParams();
        result = result * 59 + ($urlParams == null ? 43 : $urlParams.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $prepareUrl = this.getPrepareUrl();
        result = result * 59 + ($prepareUrl == null ? 43 : $prepareUrl.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $oracleParam = this.getOracleParam();
        result = result * 59 + ($oracleParam == null ? 43 : $oracleParam.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataSourceUtil(dbType=" + this.getDbType() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", serviceName=" + this.getServiceName() + ", dbName=" + this.getDbName() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", dbTableSpace=" + this.getDbTableSpace() + ", dbSchema=" + this.getDbSchema() + ", urlParams=" + this.getUrlParams() + ", url=" + this.getUrl() + ", prepareUrl=" + this.getPrepareUrl() + ", driver=" + this.getDriver() + ", oracleParam=" + this.getOracleParam() + ")";
    }
}

