/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.exception.DataException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class DbTypeUtil {
    public static DbBase getDb(DbSourceOrDbLink dbSourceOrDbLink) throws DataException {
        String dbSourceOrDbLinkEncode = DbTypeUtil.getEncode(dbSourceOrDbLink.init());
        return DbTypeUtil.getDbCommon(dbSourceOrDbLinkEncode);
    }

    public static DbBase getDb(Connection conn) {
        try {
            return DbTypeUtil.getDb(conn.getMetaData().getURL());
        }
        catch (DataException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DbBase getDb(String url) throws DataException {
        String dbType = url.split(":")[1];
        for (DbBase dbBase : DbBase.DB_BASES) {
            if (!dbType.equals(dbBase.getConnUrlEncode())) continue;
            return dbBase;
        }
        throw new DataException(MsgCode.DB003.get());
    }

    public static DbBase getEncodeDb(String dbEncode) throws DataException {
        for (DbBase dbBase : DbBase.DB_BASES) {
            if (!dbEncode.equals(dbBase.getDbEncode())) continue;
            return dbBase;
        }
        throw new DataException(MsgCode.DB003.get());
    }

    public static DbBase getDriver(String dbType) throws DataException {
        for (DbBase dbBase : DbBase.DB_BASES) {
            if (!dbBase.getDbEncode().contains(dbType)) continue;
            return dbBase;
        }
        throw new DataException(MsgCode.DB003.get());
    }

    private static Boolean checkDb(DbSourceOrDbLink dataSourceMod, String encode) {
        DbLinkEntity dataSourceDTO = dataSourceMod.init();
        String dataSourDbEncode = null;
        try {
            dataSourDbEncode = DbTypeUtil.getEncode(dataSourceDTO);
        }
        catch (DataException e) {
            e.printStackTrace();
        }
        return encode.equals(dataSourDbEncode);
    }

    public static Boolean checkOracle(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "Oracle");
    }

    public static Boolean checkMySQL(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "MySQL");
    }

    public static Boolean checkSQLServer(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "SQLServer");
    }

    public static Boolean checkDM(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "DM8");
    }

    public static Boolean checkKingbase(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "KingbaseES");
    }

    public static Boolean checkPostgre(DbSourceOrDbLink dataSourceMod) {
        return DbTypeUtil.checkDb(dataSourceMod, "PostgreSQL");
    }

    public static <T extends DataSourceUtil> DbType getMybatisEnum(T dataSourceUtil) throws DataException {
        return DbTypeUtil.getDb(dataSourceUtil).getMpDbType();
    }

    public static Boolean compare(String dbType1, String dbType2) throws DataException {
        dbType1 = DbTypeUtil.checkDbTypeExist(dbType1, false);
        dbType2 = DbTypeUtil.checkDbTypeExist(dbType2, false);
        if (dbType1 != null && dbType2 != null) {
            return dbType1.equals(dbType2);
        }
        return false;
    }

    private static String getEncode(DbLinkEntity dataSourceDTO) throws DataException {
        return DbTypeUtil.checkDbTypeExist(dataSourceDTO.getDbType(), true);
    }

    private static DbBase getDbCommon(String encode) {
        for (DbBase db : DbBase.DB_BASES) {
            if (!db.getDbEncode().equalsIgnoreCase(encode)) continue;
            return db;
        }
        return null;
    }

    private static String checkDbTypeExist(String dbType, Boolean exceptionOnOff) throws DataException {
        for (String enEncode : DbBase.DB_ENCODES) {
            if (!enEncode.equals(dbType)) continue;
            return enEncode;
        }
        if (exceptionOnOff.booleanValue()) {
            throw new DataException(MsgCode.DB001.get());
        }
        return null;
    }

    public static String getDbEncodeByProductName(String databaseProductName) {
        switch (databaseProductName.toUpperCase()) {
            case "MYSQL": {
                return "MySQL";
            }
            case "ORACLE": {
                return "Oracle";
            }
            case "POSTGRESQL": {
                return "PostgreSQL";
            }
            case "KINGBASEES": {
                return "KingbaseES";
            }
            case "MICROSOFT SQL SERVER": {
                return "SQLServer";
            }
            case "DM DBMS": {
                return "DM8";
            }
        }
        return databaseProductName.toUpperCase();
    }

    public static boolean needToLowerCase(String dbType) {
        ArrayList<String> lowerDb = new ArrayList<String>();
        lowerDb.add("PostgreSQL");
        lowerDb.add("KingbaseES");
        return lowerDb.contains(dbType);
    }

    public static boolean needToUpperCase(String databaseProductName) {
        return databaseProductName.contains("Oracle") || databaseProductName.contains("DM8");
    }
}

