/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.filter;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.router.SaRouter;
import com.bringspring.common.properties.MvcSecurityProperties;
import com.bringspring.common.util.IpUtil;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration(proxyBeanMethods=false)
public class MvcSecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcSecurityConfig.class);
    private static final String DOMAIN_FORMAT = "%s://%s";
    @Autowired
    private MvcSecurityProperties mvcSecurityProperties;

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setAllowedOrigins(this.mvcSecurityProperties.getCors().getAllowedOrigins());
        config.setAllowedOriginPatterns(this.mvcSecurityProperties.getCors().getAllowedOriginPatterns());
        config.setAllowedHeaders(this.mvcSecurityProperties.getCors().getAllowedHeaders());
        config.setAllowedMethods(this.mvcSecurityProperties.getCors().getAllowedMethods());
        source.registerCorsConfiguration("/**", config);
        return new MyCorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnMissingBean
    public SaFilterAuthStrategy defaultBeforeAuthStrategy() {
        CorsConfiguration csrfConfiguration;
        if (!this.mvcSecurityProperties.getCsrfOrigins().isEmpty() || !this.mvcSecurityProperties.getCsrfOriginsPatterns().isEmpty()) {
            csrfConfiguration = new CorsConfiguration();
            csrfConfiguration.setAllowedOrigins(this.mvcSecurityProperties.getCsrfOrigins());
            csrfConfiguration.setAllowedOriginPatterns(this.mvcSecurityProperties.getCsrfOriginsPatterns());
        } else {
            csrfConfiguration = null;
        }
        return obj -> {
            URI uri;
            String refererDomain;
            String allowOrign;
            String referer;
            SaRequest request = SaHolder.getRequest();
            SaResponse response = SaHolder.getResponse();
            if (!ObjectUtils.isEmpty((Object)this.mvcSecurityProperties.getHeaders().getServerName())) {
                response.setServer(this.mvcSecurityProperties.getHeaders().getServerName());
            }
            if (!ObjectUtils.isEmpty((Object)((Object)this.mvcSecurityProperties.getHeaders().getXFrameOptions())) && !MvcSecurityProperties.XFrameOptionsMode.DISABLED.equals((Object)this.mvcSecurityProperties.getHeaders().getXFrameOptions())) {
                response.setHeader("X-Frame-Options", this.mvcSecurityProperties.getHeaders().getXFrameOptions().getMode());
            }
            if (!ObjectUtils.isEmpty((Object)((Object)this.mvcSecurityProperties.getHeaders().getXXssProtection())) && !MvcSecurityProperties.XXssProtectionMode.DISABLED.equals((Object)this.mvcSecurityProperties.getHeaders().getXXssProtection())) {
                response.setHeader("X-XSS-Protection", this.mvcSecurityProperties.getHeaders().getXXssProtection().getMode());
            }
            if (!ObjectUtils.isEmpty((Object)((Object)this.mvcSecurityProperties.getHeaders().getXContentTypeOptions())) && !MvcSecurityProperties.XContentTypeOptions.DISABLED.equals((Object)this.mvcSecurityProperties.getHeaders().getXContentTypeOptions())) {
                response.setHeader("X-Content-Type-Options", this.mvcSecurityProperties.getHeaders().getXContentTypeOptions().getMode());
            }
            if (csrfConfiguration != null && !ObjectUtils.isEmpty((Object)(referer = request.getHeader("referer"))) && ObjectUtils.isEmpty((Object)(allowOrign = csrfConfiguration.checkOrigin(refererDomain = String.format(DOMAIN_FORMAT, (uri = URI.create(referer)).getScheme(), uri.getAuthority()))))) {
                log.error("Reject CSRF Request: {}, {}, {}, {}", new Object[]{request.getRequestPath(), referer, IpUtil.getIpAddr(), request.getHeader("Authorization")});
                response.setStatus(HttpStatus.FORBIDDEN.value());
                SaRouter.back((Object)"Invalid CSRF Request");
            }
        };
    }

    @Order(value=-110)
    public static class MyCorsFilter
    extends CorsFilter {
        public MyCorsFilter(CorsConfigurationSource configSource) {
            super(configSource);
        }
    }
}

