/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.security.config;

import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.fun.strategy.SaHasElementFunction;
import cn.dev33.satoken.interceptor.SaInterceptor;
import cn.dev33.satoken.same.SaSameUtil;
import cn.dev33.satoken.strategy.SaAnnotationStrategy;
import cn.dev33.satoken.strategy.SaStrategy;
import com.bringspring.common.annotation.SaCheckSame;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.security.encrypt.EncryptRestInterceptor;
import com.bringspring.common.security.filter.ClearThreadContextFilter;
import com.bringspring.common.security.filter.RequestWrapperFilter;
import com.bringspring.common.security.filter.SecurityFilter;
import com.bringspring.common.security.handler.IRestHandler;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import jakarta.servlet.Filter;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class SecurityConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Autowired
    private SecurityProperties securityProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        this.initSaInterfaceAuth(registry);
        this.initEncryptRestInterceptor(registry);
    }

    @Bean(value={"myRequestWrapperFilter"})
    @ConditionalOnMissingBean(name={"myRequestWrapperFilter"})
    public Filter getRequestWrapperFilter(List<IRestHandler> handlers) {
        return new RequestWrapperFilter(handlers, this.securityProperties);
    }

    @Bean(value={"myClearThreadContextFilter"})
    @ConditionalOnMissingBean(name={"myClearThreadContextFilter"})
    public Filter getClearThreadContextFilter() {
        return new ClearThreadContextFilter();
    }

    @Bean(value={"mySecurityFilter"})
    @ConditionalOnMissingBean(name={"mySecurityFilter"})
    public Filter getSecurityFilter(SecurityProperties securityProperties, ConfigValueUtil configValueUtil) {
        return new SecurityFilter(securityProperties, configValueUtil).addInclude(new String[]{"/**"});
    }

    @Bean(value={"myEncryptRestInterceptor"})
    @ConditionalOnMissingBean(name={"myEncryptRestInterceptor"})
    @ConditionalOnProperty(prefix="security", name={"enable-rest-encrypt"}, havingValue="true")
    public HandlerInterceptor getEncryptRestInterceptor() {
        return new EncryptRestInterceptor();
    }

    protected void initEncryptRestInterceptor(InterceptorRegistry registry) {
        if (this.securityProperties.isEnableRestEncrypt()) {
            registry.addInterceptor((HandlerInterceptor)SpringContext.getBean("myEncryptRestInterceptor"));
        }
    }

    protected void initSaInterfaceAuth(InterceptorRegistry registry) {
        if (this.securityProperties.isEnablePreAuth()) {
            SaAnnotationStrategy.instance.registerAnnotationHandler((SaAnnotationHandlerInterface)new SaAnnotationHandlerInterface<SaCheckSame>(this){

                public Class<SaCheckSame> getHandlerAnnotationClass() {
                    return SaCheckSame.class;
                }

                public void checkMethod(SaCheckSame at, AnnotatedElement element) {
                    SaSameUtil.checkToken((String)SaHolder.getRequest().getHeader("SA-SAME-TOKEN"));
                }
            });
            registry.addInterceptor((HandlerInterceptor)new SaInterceptor().isAnnotation(this.securityProperties.isEnablePreAuth())).addPathPatterns(new String[]{"/**"});
        }
        SaHasElementFunction oldCheckFunc = SaStrategy.instance.hasElement;
        SaStrategy.instance.hasElement = (arg_0, arg_1) -> this.lambda$initSaInterfaceAuth$0((BiFunction)oldCheckFunc, arg_0, arg_1);
    }

    private /* synthetic */ Boolean lambda$initSaInterfaceAuth$0(BiFunction oldCheckFunc, List list, String element) {
        if (this.securityProperties.isEnablePreAuth()) {
            String innerToken;
            UserInfo userInfo = UserProvider.getUser();
            if (StringUtils.isEmpty(userInfo.getUserId())) {
                return false;
            }
            if (userInfo.getIsAdministrator().booleanValue()) {
                return true;
            }
            boolean result = (Boolean)oldCheckFunc.apply(list, element);
            if (!result && UserProvider.isValidInnerToken(innerToken = SaHolder.getRequest().getHeader("SA-SAME-TOKEN"))) {
                result = true;
            }
            return result;
        }
        return true;
    }
}

