/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final int BUFFER_SIZE = 2048;

    public static boolean fileIsExists(String filePath) {
        File f = new File(XSSEscape.escapePath(filePath));
        return f.exists();
    }

    public static boolean fileIsFile(String filePath) {
        File f = new File(XSSEscape.escapePath(filePath));
        return f.isFile();
    }

    public static boolean createFile(String filePath, String fileName) {
        File subfile;
        String strFilePath = XSSEscape.escapePath(filePath + fileName);
        File file = new File(XSSEscape.escapePath(filePath));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(subfile = new File(strFilePath)).exists()) {
            try {
                boolean b = subfile.createNewFile();
                return b;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return true;
        }
        return false;
    }

    public static void createDirs(String filePath) {
        File file = new File(XSSEscape.escapePath(filePath));
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static List<File> getFile(File file) {
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return list;
        }
        for (File f : fileArray) {
            if (!f.isFile()) continue;
            list.add(0, f);
        }
        return list;
    }

    public static List<File> getFile(File file, List<File> list) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return list;
        }
        for (File f : fileArray) {
            if (f.isFile()) {
                list.add(0, f);
                continue;
            }
            FileUtil.getFile(f, list);
        }
        return list;
    }

    public static void deleteFileAll(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                log.info(file.getAbsolutePath() + " \u5220\u9664\u4e2d...");
                file.delete();
                log.info("\u5220\u9664\u6210\u529f\uff01");
                return;
            }
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.deleteFileAll(files[i]);
            }
            file.delete();
        } else {
            log.info(file.getAbsolutePath() + " \u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
    }

    public static void deleteFile(String filePath) {
        File file = new File(XSSEscape.escapePath(filePath));
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static void deleteEmptyDirectory(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteEmptyDirectory(files[i]);
                }
                files = file.listFiles();
            }
            if (files == null || files.length == 0) {
                String absolutePath = file.getAbsolutePath();
                file.delete();
                log.info("\u5220\u9664\u7a7a\u6587\u4ef6\u5939\uff01\u8def\u5f84\uff1a" + absolutePath);
            }
        }
    }

    public static boolean deleteTmp(MultipartFile multipartFile) {
        try {
            log.debug("\u4e34\u65f6\u6587\u4ef6\u5c06\u7531\u6846\u67b6\u81ea\u52a8\u6e05\u7406: " + multipartFile.getOriginalFilename());
            return true;
        }
        catch (Exception e) {
            log.error("\u5220\u9664tmp\u6587\u4ef6\u5931\u8d25,\u9519\u8bef\uff1a" + e.getMessage());
            return false;
        }
    }

    public static void open(String path) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + path);
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + path);
                } else {
                    log.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + path);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(String strcontent, String filePath, String fileName) {
        String strFilePath = filePath + fileName;
        File subfile = new File(XSSEscape.escapePath(strFilePath));
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(subfile, "rw");
            raf.seek(subfile.length());
            raf.write(strcontent.getBytes());
            raf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyFile(String path, String content, boolean append) {
        try {
            FileWriter fileWriter = new FileWriter(path, append);
            try {
                BufferedWriter writer = new BufferedWriter(fileWriter);
                try {
                    writer.append(content);
                    writer.flush();
                    writer.close();
                }
                finally {
                    if (Collections.singletonList(writer).get(0) != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(fileWriter).get(0) != null) {
                    fileWriter.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String filePath, String filename) {
        StringBuffer sb = new StringBuffer("");
        try {
            FileInputStream inputStream = new FileInputStream(new File(XSSEscape.escapePath(filePath + filename)));
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                try {
                    BufferedReader reader = new BufferedReader(inputStreamReader);
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            sb.append(line);
                            sb.append("\n");
                        }
                    }
                    finally {
                        if (Collections.singletonList(reader).get(0) != null) {
                            reader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(inputStreamReader).get(0) != null) {
                        inputStreamReader.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void renameFile(String oldPath, String newPath) {
        File oleFile = new File(oldPath);
        File newFile = new File(newPath);
        oleFile.renameTo(newFile);
    }

    public static boolean copy(String fromFile, String toFile) {
        File root = new File(fromFile);
        if (!root.exists()) {
            return false;
        }
        File[] currentFiles = root.listFiles();
        File targetDir = new File(toFile);
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        for (int i = 0; i < currentFiles.length; ++i) {
            if (currentFiles[i].isDirectory()) {
                FileUtil.copy(currentFiles[i].getPath() + "/", toFile + currentFiles[i].getName() + "/");
                continue;
            }
            FileUtil.copyFile(currentFiles[i].getPath(), toFile + currentFiles[i].getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String fromFile, String toFile) {
        try {
            FileInputStream fosfrom = new FileInputStream(XSSEscape.escapePath(fromFile));
            try {
                boolean bl;
                block11: {
                    FileOutputStream fosto = new FileOutputStream(XSSEscape.escapePath(toFile));
                    try {
                        int c;
                        byte[] bt = new byte[1024];
                        while ((c = ((InputStream)fosfrom).read(bt)) > 0) {
                            ((OutputStream)fosto).write(bt, 0, c);
                        }
                        ((InputStream)fosfrom).close();
                        ((OutputStream)fosto).close();
                        bl = true;
                        if (Collections.singletonList(fosto).get(0) == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(fosto).get(0) != null) {
                            ((OutputStream)fosto).close();
                        }
                        throw throwable;
                    }
                    ((OutputStream)fosto).close();
                }
                return bl;
            }
            finally {
                if (Collections.singletonList(fosfrom).get(0) != null) {
                    ((InputStream)fosfrom).close();
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String fromFile, String toFile, String fileName) {
        try {
            File targetDir = new File(toFile);
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            FileInputStream fosfrom = new FileInputStream(fromFile);
            try {
                boolean bl;
                block12: {
                    FileOutputStream fosto = new FileOutputStream(toFile + fileName);
                    try {
                        int c;
                        byte[] bt = new byte[1024];
                        while ((c = ((InputStream)fosfrom).read(bt)) > 0) {
                            ((OutputStream)fosto).write(bt, 0, c);
                        }
                        ((InputStream)fosfrom).close();
                        ((OutputStream)fosto).close();
                        bl = true;
                        if (Collections.singletonList(fosto).get(0) == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(fosto).get(0) != null) {
                            ((OutputStream)fosto).close();
                        }
                        throw throwable;
                    }
                    ((OutputStream)fosto).close();
                }
                return bl;
            }
            finally {
                if (Collections.singletonList(fosfrom).get(0) != null) {
                    ((InputStream)fosfrom).close();
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream inputStream, String path, String fileName) {
        OutputStream os = null;
        long dateStr = System.currentTimeMillis();
        try {
            int len;
            byte[] bs = new byte[1024];
            File tempFile = new File(XSSEscape.escapePath(path));
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            String newFileName = tempFile.getPath() + File.separator + fileName;
            log.info("\u4fdd\u5b58\u6587\u4ef6\uff1a" + newFileName);
            os = new FileOutputStream(XSSEscape.escapePath(newFileName));
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (IOException e) {
            log.error("\u751f\u6210excel\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u751f\u6210excel\u5931\u8d25");
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u94fe\u63a5\u5931\u8d25" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(InputStream inputStream, String path, String fileName) {
        OutputStream os = null;
        try {
            int len;
            byte[] bs = new byte[1024];
            File tempFile = new File(XSSEscape.escapePath(path));
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            String newFileName = tempFile.getPath() + File.separator + fileName;
            log.info("\u4fdd\u5b58\u6587\u4ef6\uff1a" + newFileName);
            os = new FileOutputStream(XSSEscape.escapePath(newFileName));
            while ((len = inputStream.read(bs)) != -1) {
                os.write(bs, 0, len);
            }
        }
        catch (IOException e) {
            log.error("\u751f\u6210excel\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u751f\u6210excel\u5931\u8d25");
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95ed\u94fe\u63a5\u5931\u8d25" + e.getMessage());
            }
        }
    }

    public static void upFile(MultipartFile file, String filePath, String fileName) {
        try {
            String escapeFilePath = XSSEscape.escape(filePath);
            String escapeFileName = XSSEscape.escape(fileName);
            File tempFile = new File(escapeFilePath);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            }
            File f = new File(escapeFilePath, escapeFileName);
            file.transferTo(f);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static String getCreateTime(String filePath) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        File file = new File(XSSEscape.escapePath(filePath));
        long modifiedTime = file.lastModified();
        Date date = new Date(modifiedTime);
        String dateString = format.format(date);
        return dateString;
    }

    public static String getFileType(File file) {
        if (file.isFile()) {
            String fileName = file.getName();
            String fileTyle = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            return fileTyle;
        }
        return null;
    }

    public static String getFileType(String fileName) {
        int lastIndexOf = fileName.lastIndexOf(".") + 1;
        String suffix = fileName.substring(lastIndexOf);
        return suffix;
    }

    public static String getSize(String data) {
        Object size = "";
        if (data != null && !StringUtils.isEmpty(data)) {
            long fileS = Long.parseLong(data);
            DecimalFormat df = new DecimalFormat("#.00");
            size = fileS < 1024L ? df.format((double)fileS) + "BT" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        } else {
            size = "0BT";
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toZip(String outDir, boolean keepDirStructure, String ... srcDir) {
        try {
            FileOutputStream out = new FileOutputStream(new File(XSSEscape.escapePath(outDir)));
            try {
                ZipOutputStream zos = null;
                try {
                    try {
                        zos = new ZipOutputStream(out);
                        ArrayList<File> sourceFileList = new ArrayList<File>();
                        for (String dir : srcDir) {
                            File sourceFile = new File(XSSEscape.escapePath(dir));
                            sourceFileList.add(sourceFile);
                        }
                        FileUtil.compress(sourceFileList, zos, keepDirStructure);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("zip error from ZipUtils", e);
                    }
                    finally {
                        if (zos != null) {
                            try {
                                zos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(zos).get(0) != null) {
                        zos.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toZipAll(String outDir, boolean keepDirStructure, List<String> srcDir) {
        try {
            FileOutputStream out = new FileOutputStream(new File(XSSEscape.escapePath(outDir)));
            try {
                ZipOutputStream zos = null;
                try {
                    try {
                        zos = new ZipOutputStream(out);
                        ArrayList<File> sourceFileList = new ArrayList<File>();
                        for (String dir : srcDir) {
                            File sourceFile = new File(XSSEscape.escapePath(dir));
                            sourceFileList.add(sourceFile);
                        }
                        FileUtil.compress(sourceFileList, zos, keepDirStructure);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("zip error from ZipUtils", e);
                    }
                    finally {
                        if (zos != null) {
                            try {
                                zos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(zos).get(0) != null) {
                        zos.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            try {
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        FileUtil.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    FileUtil.compress(file, zos, file.getName(), keepDirStructure);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(List<File> sourceFileList, ZipOutputStream zos, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        for (File sourceFile : sourceFileList) {
            String name = sourceFile.getName();
            if (sourceFile.isFile()) {
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = new FileInputStream(sourceFile);
                try {
                    int len;
                    while ((len = in.read(buf)) != -1) {
                        zos.write(buf, 0, len);
                    }
                    zos.closeEntry();
                    in.close();
                    continue;
                }
                finally {
                    if (Collections.singletonList(in).get(0) != null) {
                        in.close();
                    }
                    continue;
                }
            }
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (!keepDirStructure) continue;
                zos.putNextEntry(new ZipEntry(name + "/"));
                zos.closeEntry();
                continue;
            }
            for (File file : listFiles) {
                if (keepDirStructure) {
                    FileUtil.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                    continue;
                }
                FileUtil.compress(file, zos, file.getName(), keepDirStructure);
            }
        }
    }

    public static boolean fileType(String fileType, String fileExtension) {
        String[] allowExtension = fileType.split(",");
        return Arrays.asList(allowExtension).contains(fileExtension.toLowerCase());
    }

    public static boolean imageType(String imageType, String fileExtension) {
        String[] allowExtension = imageType.split(",");
        return Arrays.asList(allowExtension).contains(fileExtension.toLowerCase());
    }

    public static boolean fileSize(Long fileSize, int maxSize) {
        return fileSize > (long)maxSize;
    }

    public static String getFileContent(MultipartFile multipartFile, String filePath) {
        String fileName = multipartFile.getName();
        FileUtil.upFile(multipartFile, filePath, fileName);
        String fileContent = FileUtil.getString(filePath, fileName);
        return fileContent;
    }

    public static boolean existsSuffix(MultipartFile multipartFile, String type) {
        return !multipartFile.getOriginalFilename().endsWith("." + type) || multipartFile.getSize() < 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartFile createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                OutputStream os = item.getOutputStream();
                while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.close();
                fis.close();
            }
            finally {
                if (Collections.singletonList(fis).get(0) != null) {
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

