package com.bringspring.common.auth.config;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.jwt.StpLogicJwtForSimple;
import cn.dev33.satoken.stp.StpLogic;
import com.bringspring.common.auth.consts.AuthConsts;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;


/**
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Configuration
public class AuthAutoConfigration {


    @Primary
    @Bean
    @ConfigurationProperties(prefix = "oauth.login")
    public SaTokenConfig getJsbosTokenConfig() {
        return new JsbosTokenConfig();
    }


    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix = JsbosOauthConfig.PREFIX)
    public JsbosOauthConfig getJsbosOauthConfig() {
        return new JsbosOauthConfig();
    }

    @Primary
    @Bean(AuthConsts.ACCOUNT_LOGIC_BEAN_DEFAULT)
    public StpLogic getJsbosTokenJwtLogic() {
        return new StpLogicJwtForSimple(AuthConsts.ACCOUNT_TYPE_DEFAULT);
    }

    @Bean(AuthConsts.ACCOUNT_LOGIC_BEAN_TENANT)
    public StpLogic getJsbosTenantTokenJwtLogic() {
        return new StpLogicJwtForSimple(AuthConsts.ACCOUNT_TYPE_TENANT);
    }
}
