package com.bringspring.common.auth.consts;

import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * @author RKKJ开发平台组
 * @copyright 荣科科技股份有限公司
 */
@Getter
@AllArgsConstructor
public enum LoginTicketStatus {

    /**
     * 登录成功
     */
    Success(1),
    /**
     * 未登录
     */
    UnLogin(2),
    /**
     * 登录失败
     */
    ErrLogin(3),
    /**
     * 未绑定
     */
    UnBind(4),
    /**
     * 失效
     */
    Invalid(5),
    /**
     * 多租户
     */
    Multitenancy(6),
    /**
     * 第三方账号未绑定账号，请绑定后重试
     */
    UnBindMes(7),
    ;

    private int status;
}
