package com.bringspring.common.database.model.dto;

import com.bringspring.common.database.util.DataSourceUtil;
import lombok.Data;

/**
 * 数据源参数传输对象
 * -- 注意：这里的参数dataSourceUtil是spring托管的全局唯一变量，此数据传输对象防止数据源互串
 *
 * @author RKKJ开发平台组 YanYu
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/28
 */
@Data
public class DataSourceDTO extends DataSourceUtil {

    /**
     * 数据来源
     * 0：自身创建  1：配置  2：数据连接
     */
    private Integer dataSourceFrom;

    /**
     * 表名
     */
    private String tableName;

}
