package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.constant.DbConst;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlDM;
import com.bringspring.common.database.sql.model.DbStruct;
import com.bringspring.common.database.util.DataSourceUtil;

import java.util.LinkedList;

/**
 * 达梦模型
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/10/06
 */
public class DbDM extends DbBase {

    @Override
    protected void init() {
        setInstance(
                DbBase.DM,
                DbType.DM,
                "5236",
                "dm",
                "dm.jdbc.driver.DmDriver",
                "jdbc:dm://{host}:{port}/{schema}",
                new SqlDM());
    }

    @Override
    protected String getConnUrl(String prepareUrl, String host, Integer port, DbStruct struct){
        prepareUrl = super.getConnUrl(prepareUrl, host, port, null);
        return prepareUrl.replace(DbConst.DB_SCHEMA, struct.getDmDbSchema());
    }

    @Override
    public LinkedList<Object> getStructParams(String structParams, String table, DataSourceUtil dbSourceOrDbLink) {
        DataSourceDTO dataSourceDTO = dbSourceOrDbLink.convertDTO();
        dataSourceDTO.setDbSchema(dataSourceDTO.getUserName());
        return super.getStructParams(structParams, table, dataSourceDTO);
    }


//    public static void setDmTableModel(DbConnDTO connDTO, List<DbTableModel> tableModelList) {
//        //达梦特殊方法
//        try {
//            @Cleanup Connection dmConn = connDTO.getConn();
//            tableModelList.forEach(tm -> {
//                try {
//                    Integer sum = DbDM.getSum(dmConn, tm.getTable());
//                    tm.setSum(sum);
//                } catch (DataException e) {
//                    e.printStackTrace();
//                }
//            });
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    private static Integer getSum(Connection connection, String table) throws DataException {
//        String sql = "SELECT COUNT(*) as F_SUM FROM " + table;
//        return JdbcUtil.queryOneInt(connection, sql, "F_SUM");
//    }

}
