package com.bringspring.common.filter;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.context.SpringContext;
import jakarta.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.bringspring.common.constant.CacheConsts.REPEATSUBMIT_CACHE;

/**
 * @author rikylinz
 * @description 判断请求url和数据是否和上一次相同，如果和上次相同，则是重复提交表单。 有效时间为5秒内。
 * @date 2022/11/15 11:21
 */
@Slf4j
@Component
public class RepeatSubmitRule extends RepeatSubmitInterceptor {

    public final String REPEAT_PARAMS = "repeatParams";

    public final String REPEAT_TIME = "repeatTime";

    /**
     * 防重提交 redis key
     */
    public static final String REPEAT_SUBMIT_KEY = "repeat_submit:";

//    @Autowired
//    private RedisUtil redisUtil;

    @Override
    public boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit annotation) {
         CacheUtil cacheUtil = SpringContext.getBean(CacheUtil.class);
//        UserPo user = ThreadLocalUtil.getUser();
//        String mobile = user.getMobile();
        String mobile = request.getHeader("Authorization");
        int interval = 3000;
        if (ObjectUtil.isNotNull(annotation)){
            interval = annotation.interval();
        }
        String nowParams = "";
        if (request instanceof RepeatedlyRequestWrapper) {
            RepeatedlyRequestWrapper repeatedlyRequest = (RepeatedlyRequestWrapper) request;
            //获取body中的数据方法下面会有展示
            nowParams = HttpUtil.getBodyString(repeatedlyRequest);
        }else{
            //获取body中的数据方法下面会有展示
            nowParams = HttpUtil.getBodyString(request);
        }

        // body参数为空，获取Parameter的数据
        if (StringUtils.isEmpty(nowParams))
        {
            nowParams = JSON.toJSONString(request.getParameterMap());
        }
        Map<String, Object> nowDataMap = new HashMap<>();
        nowDataMap.put(REPEAT_PARAMS, nowParams);
        nowDataMap.put(REPEAT_TIME, System.currentTimeMillis());

        // 请求地址（作为存放cache的key值）
        String url = request.getRequestURI();

        // 唯一标识（指定key + url + 手机号）
        String cacheRepeatKey = REPEAT_SUBMIT_KEY + url + mobile;

        Map<String, Object> cacheMap = new HashMap<>();
        cacheMap.put(url, nowDataMap);
        //原子操作  添加  返回结果   true 添加成功(redis不存在)  false 添加失败
        Boolean isExist = null;
        try {
            isExist = cacheUtil.setStringByAtomicity(cacheRepeatKey, JSON.toJSONString(cacheMap),
                    Integer.valueOf(interval).longValue(), TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            log.error("[校验防重复提交]原子性添加数据失败，原因:{}",e);
            return false;
        }

        if (Boolean.FALSE.equals(isExist))
        {
            Object sessionObj = null;
            try {
                sessionObj = cacheUtil.query(REPEATSUBMIT_CACHE, cacheRepeatKey);
            } catch (Exception e) {
                log.error("[校验防重复提交]redis获取数据失败，原因:{}",e);
                return false;
            }
            JSONObject sessionMap = JSONObject.parseObject(sessionObj.toString());
            if (sessionMap.containsKey(url))
            {
                Map<String, Object> preDataMap = (Map<String, Object>) sessionMap.get(url);
                if (compareParams(nowDataMap, preDataMap) && compareTime(nowDataMap, preDataMap, interval))
                {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 判断参数是否相同
     */
    private boolean compareParams(Map<String, Object> nowMap, Map<String, Object> preMap)
    {
        String nowParams = (String) nowMap.get(REPEAT_PARAMS);
        String preParams = (String) preMap.get(REPEAT_PARAMS);
        return nowParams.equals(preParams);
    }

    /**
     * 判断两次间隔时间
     */
    private boolean compareTime(Map<String, Object> nowMap, Map<String, Object> preMap, int interval)
    {
        long time1 = (Long) nowMap.get(REPEAT_TIME);
        long time2 = (Long) preMap.get(REPEAT_TIME);
        if ((time1 - time2) < interval)
        {
            return true;
        }
        return false;
    }
}

