package com.bringspring.common.i18n.provider;


import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Properties;

/**
 * 动态翻译文件获取
 */
public interface DynamicMessageProvider {


    /**
     * 返回语言配置Properties文件字符串
     *
     * @param locale
     * @return
     */
    String getI18nList(Locale locale);

    /**
     * 返回语言配置Properties
     *
     * @param locale
     * @return
     */
    default Properties getI18nListProperties(Locale locale) {
        String i18nList = getI18nList(locale);
        if (i18nList != null) {
            Properties properties = new Properties();
            try {
                properties.load(new StringReader(i18nList));
                return properties;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }


}
