package com.bringspring.common.license.utils;

import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class MacOSServerInfo extends AbstractServerInfo {
    public MacOSServerInfo() {
    }

    
    // Mac系统为标识设备硬件生成的唯一标识符。它是与设备的硬件绑定的，并且通常与多种硬件组件结合在一起生成。
    // 它并不对应单一的硬件组件（例如CPU或主板），而是整个设备的唯一标识，用于在软件层面上区分不同的Mac设备。
    public String getCPUSerial() throws Exception {
        String serialNumber = "";
        String[] shell = new String[]{"/bin/bash", "-c", "system_profiler SPHardwareDataType | grep 'UUID' | awk '{print $3}'"};
        Process process = Runtime.getRuntime().exec(shell);
        process.getOutputStream().close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine().trim();
        if (StringUtils.isNotBlank(line)) {
            serialNumber = line;
        }

        reader.close();
        return serialNumber;
    }

    // 主板的序列号
    public String getMainBoardSerial() throws Exception {
        String serialNumber = "";
        String[] shell = new String[]{"/bin/bash", "-c", "ioreg -l | grep IOPlatformSerialNumber | awk -F '\"' '{print $4}'"};
        Process process = Runtime.getRuntime().exec(shell);
        process.getOutputStream().close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine().trim();
        if (StringUtils.isNotBlank(line)) {
            serialNumber = line;
        }

        reader.close();
        return serialNumber;
    }
}