package com.bringspring.common.security.filter;

import com.bringspring.common.properties.SecurityProperties;
import com.bringspring.common.security.handler.IRestHandler;
import com.bringspring.common.security.wrapper.MyRequestWrapper;
import com.bringspring.common.security.wrapper.MyResponseWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;

import java.io.IOException;
import java.util.List;

/**
 * 请求内容
 */
@Slf4j
@Order(-97)
public class RequestWrapperFilter extends OncePerRequestFilter {

    private List<IRestHandler> handlers;
    private SecurityProperties securityProperties;

    public RequestWrapperFilter(List<IRestHandler> handlers, SecurityProperties securityProperties) {
        this.handlers = handlers;
        this.securityProperties = securityProperties;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if(handlers.isEmpty()){
            filterChain.doFilter(request, response);
        } else {
            MyRequestWrapper myRequest = new MyRequestWrapper(request, handlers);
            MyResponseWrapper wrapResponse = new MyResponseWrapper(response, handlers);
            filterChain.doFilter(myRequest, wrapResponse);
            wrapResponse.doFinal();
        }
    }

}
